#!/usr/local/bin/perl

# ProAtlaso͂xmpsgpx`ɕϊ
# 2011/05/05 T-MZ

# Usage : perl xmps2gpx.pl infile > outfile

require 5.6.0;
use strict;

# 萔
our $rd = (4 * atan2(1,1)) / 180; # ~iWAj

# ϊ
# (Tokyo)
our $tokyo_a = 6377397.155;
my $tokyo_f = 1 / 299.152813;
our $tokyo_e2 = 2*$tokyo_f - $tokyo_f*$tokyo_f;

# ϊ
# (WGS 84)
our $wgs84_a = 6378137;        # ԓa
my $wgs84_f = 1 / 298.257223; # G
our $wgs84_e2 = 2*$wgs84_f - $wgs84_f*$wgs84_f;  # 1S

# sړ [m]
# e.g. $x_ = $x + $dx etc.
our $dx = -148;
our $dy = +507;
our $dz = +681;



if($#ARGV<0){
	print STDERR ("Usage: ./xmps2gpx.pl infile > outfile\n");
	exit(1);
}

# CĂяo
&mainfunc($ARGV[0]);
exit (0);


sub mainfunc {
	my ($line, $ret);
	my ($in_file);
	my ($name, $lat, $lon);
	my ($st_point);

	$st_point = 0;
	$in_file = shift;
	$ret = open (F_IN, "<$in_file");

	printf("<?xml version=\"1.0\" encoding=\"shift_jis\"?>\n");
	printf("<gpx version=\"1.1\">\n");
	printf("   <rte>\n");

	while ($line=<F_IN>){
		if ($line =~ m|<name>(.*)</name>| ){
			if ($st_point){
				# |Cg
				$name = $1;
			}else{
				# [g
				printf ("      <name>%s</name>\n", $1);
			}
		}elsif ($line =~ m|<cx unit=\"dmms\">(\d+)/(\d+)/(\d+)</cx>| ){
			$lon = $1 + ($2 / 60) + ($3 / 3600000);
		}elsif ($line =~ m|<cy unit=\"dmms\">(\d+)/(\d+)/(\d+)</cy>| ){
			$lat = $1 + ($2 / 60) + ($3 / 3600000);
		}elsif ($line =~ m|<point| ){
			# point[v enter
			$st_point = 1;
			undef($name);
			undef($lon);
			undef($lat);
		}elsif ($line =~ m|</point| ){
			# point[v out
			$st_point = 0;
			if (defined($name) && defined($lon) && defined($lat)){
				print_point($name, $lon, $lat);
			}
		}
	}
	close (F_IN);

	printf("   </rte>\n");
	printf("</gpx>\n");

}

sub print_point{
	my ($name, $lon_src, $lat_src);
	my ($alt, $lon2, $lat2, $alt2);
	my ($x, $y, $z);
	
	$name = shift;
	$lon_src = shift;
	$lat_src = shift;

	$alt = 0; # W0mƂČvZ

	# ϊ
	($x, $y, $z) = &llh2xyz($lat_src, $lon_src, $alt, $tokyo_a, $tokyo_e2);
	($lat2, $lon2, $alt2) = &xyz2llh($x+$dx, $y+$dy, $z+$dz, $wgs84_a, $wgs84_e2);

	printf("      <rtept lat=\"%f\" lon=\"%f\">\n", $lat2, $lon2);
	printf("         <name>%s</name>\n", $name);
	printf("      </rtept>\n");

	return;
}

sub llh2xyz { # ȉ~̍W -> W
  my($b, $l, $h, $a, $e2) = @_;
  my($sb, $cb, $rn, $x, $y, $z);

  $b *= $rd;
  $l *= $rd;
  $sb = sin($b);
  $cb = cos($b);
  $rn = $a / sqrt(1-$e2*$sb*$sb);

  $x = ($rn+$h) * $cb * cos($l);
  $y = ($rn+$h) * $cb * sin($l);
  $z = ($rn*(1-$e2)+$h) * $sb;

  ($x, $y, $z);
}

sub xyz2llh { # W -> ȉ~̍W
  my($x, $y, $z, $a, $e2) = @_;
  my($bda, $p, $t, $st, $ct, $b, $l, $sb, $rn, $h);
  $bda = sqrt(1-$e2); # b/a

  $p = sqrt($x*$x+$y*$y);
  $t = atan2($z, $p*$bda);
  $st = sin($t);
  $ct = cos($t);
  $b = atan2($z+$e2*$a/$bda*$st*$st*$st, $p-$e2*$a*$ct*$ct*$ct);
  $l = atan2($y, $x);

  $sb = sin($b);
  $rn = $a / sqrt(1-$e2*$sb*$sb);
  $h = $p/cos($b) - $rn;

  ($b/$rd, $l/$rd, $h);
}

