/*
Copyright (c) 2012 T-MZ

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef GPSPOS_H
#define GPSPOS_H

#include <windows.h>
#include <string>
#include <list>
#include <time.h>
#include "filter.h"

#if defined(_DEBUG)
#define ENABLE_BENCHMARK_EXAMINATION
#endif

#define CONF_IDX_X_POS 0
#define CONF_IDX_Y_POS 1
#define CONF_IDX_TIMEDIFF_H 2
#define CONF_IDX_TIMEDIFF_M 3
#define CONF_IDX_FILEDIFF_H 4
#define CONF_IDX_FILEDIFF_M 5
#define CONF_IDX_FILEDIFF_S 6
#define CONF_IDX_ZOOM 7

#define CONF_IDX_CHKBOX_GPS_FILE 0
#define CONF_IDX_CHKBOX_FONT 1
#define CONF_IDX_CHKBOX_FG_COLOR 2
#define CONF_IDX_CHKBOX_BORDER_COLOR 3
#define CONF_IDX_CHKBOX_JOSM_VIEW_AUTO 4
#define CONF_IDX_CHKBOX_JOSM_ADD 5

#define AVIUTL_CONTROL_TRACK_YSIZE 24
#define AVIUTL_CONTROL_CHECK_YSIZE 20

//#define SETUP_WINDOW_ADD_XSIZE 10
//#define SETUP_WINDOW_ADD_YSIZE 140
#define SETUP_WINDOW_ADD_XSIZE 0
#define SETUP_WINDOW_ADD_YSIZE 0

#define SETUP_WINDOW_LABEL_ADD_Y 3
#define SETUP_WINDOW_LABEL_HEIGHT 19
#define SETUP_WINDOW_LABEL_WIDTH  60
#define SETUP_WINDOW_LABEL_COLOR_WIDTH 10
#define SETUP_WINDOW_TEXTBOX_HEIGHT 19
#define SETUP_WINDOW_TEXTBOX_DISP_WIDTH  170
#define SETUP_WINDOW_TEXTBOX_COLOR_WIDTH 20
#define SETUP_WINDOW_BUTTON_HEIGHT 19
#define SETUP_WINDOW_BUTTON_NORMAL_WIDTH  40
#define SETUP_WINDOW_BUTTON_WIDE_WIDTH  70

#define SETUP_WINDOW_CONTROL_X_PADDING 5

#define ID_FONT_TEXT      1000
#define ID_FONT_BUTTON    1001
#define ID_FONT_FG_COLOR_R_TEXT 1010
#define ID_FONT_FG_COLOR_G_TEXT 1011
#define ID_FONT_FG_COLOR_B_TEXT 1012
#define ID_FONT_FG_COLOR_BUTTON 1013
#define ID_FONT_BORDER_COLOR_R_TEXT 1020
#define ID_FONT_BORDER_COLOR_G_TEXT 1021
#define ID_FONT_BORDER_COLOR_B_TEXT 1022
#define ID_FONT_BORDER_COLOR_BUTTON 1023
#define ID_START_TIME_TEXT   1030
#define ID_START_TIME_BUTTON 1031
#define ID_GPS_FILE_TEXT   1040
#define ID_GPS_FILE_BUTTON 1041
#define ID_JOSM_CTRL_VIEW_BUTTON 1050
#define ID_JOSM_CTRL_ADD_BUTTON  1051

typedef enum {
	GPSPOS_JOSM_CONTROL_VIEW = 0,
	GPSPOS_JOSM_CONTROL_ADD,
} GPSPOS_JOSM_CONTROL_TYPE;

typedef struct{
	LARGE_INTEGER counter;
	std::string file;
	int line;
} BENCHMARK_TIMESTAMP;

typedef struct{
	double lat;
	double lon;
	timeval tv;
} GPS_PosData;

typedef struct{
	int text_x;
	int text_y;
	COLORREF fg_color;
	COLORREF border_color;
	TCHAR font_name[LF_FACESIZE];
	int font_point_size;
	timeval tvStart;
} GPSPOS_SETUP_DATA;

typedef struct{
	int flag_func_proc_started;
	int flag_set_StartTime_by_uop;
	HFONT hTextFont;
	double frame_rate;
	std::list<GPS_PosData> *gps_list;
	std::list<GPS_PosData>::iterator itr_gps_list;
} GPSPOS_WORK_MEMORY;


extern void initialize_dialog(HWND hwnd, HINSTANCE hinst);
extern void onPress_GPS_file_button(HWND hwnd, FILTER *fp);
extern void onPress_font_button(HWND hwnd);
extern void onPress_fg_color_button(HWND hwnd);
extern void onPress_border_color_button(HWND hwnd);
extern void onPress_JOSM_View_button(FILTER *fp, void *editp);
extern void onPress_JOSM_AddNode_button(FILTER *fp, void *editp);
extern void onfirst_func_proc(void);
extern void onFilterConfUpdate(void);
extern bool JOSM_Remote_View(FILTER *fp, FILTER_PROC_INFO *fpip);
extern bool JOSM_RemoteControl(GPSPOS_JOSM_CONTROL_TYPE type, FILTER *fp, int frame);
extern bool JOSM_RemoteControl(std::string strCommand);
extern std::string GetFrameString(FILTER *fp,FILTER_PROC_INFO *fpip);
extern bool GetPositionFromTimeval (timeval *tv, double *lat, double *lon);
extern void ReadGpxFile(std::string strFile);
extern int ReadGpxFile_TinyXML(std::string strFile);
extern int ConvertISO8601toTimeval(std::string strTime, timeval *tv);

class CTimeStampList{
	std::list<BENCHMARK_TIMESTAMP> timelist;
	LARGE_INTEGER start_count;
	LARGE_INTEGER freq;
public :
	CTimeStampList(){};
	void StartCount();
	void AddList(std::string file, int line);
};

#endif /* GPSPOS_H */