/*
Copyright (c) 2012 T-MZ

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

//----------------------------------------------------------------------------------
//		GPSʒuvOC  for AviUtl
//----------------------------------------------------------------------------------
#include <sstream>
#include <iostream>
#include <fstream>
#include <iomanip>
#include <windows.h>
#include <wininet.h>

#include "tinyxml2.h"

#include "gpspos.h"

//---------------------------------------------------------------------
//		tB^\̒`
//---------------------------------------------------------------------
#define	TRACK_N	7														//	gbNo[̐
TCHAR	*track_name[] =		{ "X", "Y",	"UTC+H", "UTC+M", "Diff H", "Diff M", "Diff S"	};	//	gbNo[̖O
int		track_default[] =	{ 10 , 10 ,	9      ,  0     , 0       , 0       , 0			};	//	gbNo[̏l
int		track_s[] =			{ 0  ,  0 , -11    , -45    , -10     , -59     , -59		};	//	gbNo[̉l
int		track_e[] =			{ 999, 999,	15     , 45     , 100     , 59      , 59		};	//	gbNo[̏l

#define	CHECK_N	7														//	`FbN{bNX̐
TCHAR	*check_name[] = 	{ "GPS file", "Font", "Text Color", "Border Color", "JOSM view auto", "JOSM view", "JOSM add" };				//	`FbN{bNX̖O
int		check_default[] = 	{ -1        , -1    , -1          , -1            , 0               , -1         , -1         };				//	`FbN{bNX̏l (l01)

GPSPOS_SETUP_DATA setup_data;
GPSPOS_WORK_MEMORY work_mem;
CTimeStampList time_exam;
HINTERNET hInternetOpen = NULL;


FILTER_DLL filter = {
	FILTER_FLAG_WINDOW_SIZE|FILTER_FLAG_EX_INFORMATION|FILTER_FLAG_EX_DATA,
								//	FILTER_FLAG_ALWAYS_ACTIVE		: tB^ɃANeBuɂ܂
								//	FILTER_FLAG_CONFIG_POPUP		: ݒ|bvAbvj[ɂ܂
								//	FILTER_FLAG_CONFIG_CHECK		: ݒ`FbN{bNXj[ɂ܂
								//	FILTER_FLAG_CONFIG_RADIO		: ݒWI{^j[ɂ܂
								//	FILTER_FLAG_EX_DATA				: gf[^ۑo悤ɂ܂B
								//	FILTER_FLAG_PRIORITY_HIGHEST	: tB^̃vCIeBɍŏʂɂ܂
								//	FILTER_FLAG_PRIORITY_LOWEST		: tB^̃vCIeBɍŉʂɂ܂
								//	FILTER_FLAG_WINDOW_THICKFRAME	: TCYύX\ȃEBhE܂
								//	FILTER_FLAG_WINDOW_SIZE			: ݒEBhẼTCYwo悤ɂ܂
								//	FILTER_FLAG_DISP_FILTER			: \tB^ɂ܂
								//	FILTER_FLAG_EX_INFORMATION		: tB^̊gݒł悤ɂ܂
								//	FILTER_FLAG_NO_CONFIG			: ݒEBhE\Ȃ悤ɂ܂
								//	FILTER_FLAG_AUDIO_FILTER		: I[fBItB^ɂ܂
								//	FILTER_FLAG_RADIO_BUTTON		: `FbN{bNXWI{^ɂ܂
								//	FILTER_FLAG_WINDOW_HSCROLL		: XN[o[EBhE܂
								//	FILTER_FLAG_WINDOW_VSCROLL		: XN[o[EBhE܂
								//	FILTER_FLAG_IMPORT				: C|[gj[܂
								//	FILTER_FLAG_EXPORT				: GNX|[gj[܂
	FILTER_WINDOW_SIZE_ADD|SETUP_WINDOW_ADD_XSIZE,
	FILTER_WINDOW_SIZE_ADD|SETUP_WINDOW_ADD_YSIZE,
							//	ݒEChẼTCY (FILTER_FLAG_WINDOW_SIZEĂ鎞ɗL)
	"GPS Position",		//	tB^̖O
	TRACK_N,					//	gbNo[̐ (0Ȃ疼OlNULLł悢)
	track_name,					//	gbNo[̖OSւ̃|C^
	track_default,				//	gbNo[̏lSւ̃|C^
	track_s,track_e,			//	gbNo[̐l̉ (NULLȂS0`256)
	CHECK_N,					//	`FbN{bNX̐ (0Ȃ疼OlNULLł悢)
	check_name,					//	`FbN{bNX̖OSւ̃|C^
	check_default,				//	`FbN{bNX̏lSւ̃|C^
	func_proc,					//	tB^֐ւ̃|C^ (NULLȂĂ΂܂)
	func_init,					//	JnɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	func_exit,					//	IɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	NULL,						//	ݒ肪ύXꂽƂɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	func_WndProc,				//	ݒEBhEɃEBhEbZ[WɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	NULL,NULL,					//	VXeŎg܂̂ŎgpȂł
	&setup_data,				//  gf[^̈ւ̃|C^ (FILTER_FLAG_EX_DATAĂ鎞ɗL)
	sizeof(setup_data),			//  gf[^TCY (FILTER_FLAG_EX_DATAĂ鎞ɗL)
	"GPS Position version 0.20 by T-MZ",
								//  tB^ւ̃|C^ (FILTER_FLAG_EX_INFORMATIONĂ鎞ɗL)
	NULL,						//	Z[uJn钼OɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	NULL,						//	Z[uIOɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
};


//---------------------------------------------------------------------
//		tB^\̂̃|C^n֐
//---------------------------------------------------------------------
EXTERN_C FILTER_DLL __declspec(dllexport) * __stdcall GetFilterTable( void )
{
	return &filter;
}

//---------------------------------------------------------------------
//		
//---------------------------------------------------------------------
BOOL func_init( FILTER *fp )
{
	memset(&setup_data, 0, sizeof(setup_data));
	memset(&work_mem, 0, sizeof(work_mem));

	HRESULT hr = CoInitialize(NULL);
	if FAILED(hr) return FALSE;

	setup_data.text_x = 10;
	setup_data.text_y = 10;
	setup_data.fg_color = RGB(255,255,255);
	setup_data.border_color = RGB(0,255,0);

	work_mem.gps_list = new std::list<GPS_PosData>();

	return TRUE;
}

//---------------------------------------------------------------------
//		I
//---------------------------------------------------------------------
BOOL func_exit( FILTER *fp )
{
	delete work_mem.gps_list;
	CoUninitialize();
	if (NULL != hInternetOpen) InternetCloseHandle(hInternetOpen);

	return TRUE;
}



//---------------------------------------------------------------------
//		tB^֐
//---------------------------------------------------------------------
BOOL func_proc( FILTER *fp,FILTER_PROC_INFO *fpip )
{
	HFONT hFont;

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.StartCount(); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */

	if(!work_mem.flag_func_proc_started){
		onfirst_func_proc();
		work_mem.flag_func_proc_started = 1;
	}

	hFont = work_mem.hTextFont;
	std::string str_pos=GetFrameString(fp, fpip);

	fp->exfunc->draw_text(fpip->ycp_edit, fp->track[CONF_IDX_X_POS]  , fp->track[CONF_IDX_Y_POS]-1, (LPSTR)str_pos.c_str(), GetRValue(setup_data.border_color) ,GetGValue(setup_data.border_color) ,GetBValue(setup_data.border_color), 0, hFont, NULL, NULL);
	fp->exfunc->draw_text(fpip->ycp_edit, fp->track[CONF_IDX_X_POS]  , fp->track[CONF_IDX_Y_POS]+1, (LPSTR)str_pos.c_str(), GetRValue(setup_data.border_color) ,GetGValue(setup_data.border_color) ,GetBValue(setup_data.border_color), 0, hFont, NULL, NULL);
	fp->exfunc->draw_text(fpip->ycp_edit, fp->track[CONF_IDX_X_POS]-1, fp->track[CONF_IDX_Y_POS]  , (LPSTR)str_pos.c_str(), GetRValue(setup_data.border_color) ,GetGValue(setup_data.border_color) ,GetBValue(setup_data.border_color), 0, hFont, NULL, NULL);
	fp->exfunc->draw_text(fpip->ycp_edit, fp->track[CONF_IDX_X_POS]+1, fp->track[CONF_IDX_Y_POS]  , (LPSTR)str_pos.c_str(), GetRValue(setup_data.border_color) ,GetGValue(setup_data.border_color) ,GetBValue(setup_data.border_color), 0, hFont, NULL, NULL);
	fp->exfunc->draw_text(fpip->ycp_edit, fp->track[CONF_IDX_X_POS]  , fp->track[CONF_IDX_Y_POS]  , (LPSTR)str_pos.c_str(), GetRValue(setup_data.fg_color) ,GetGValue(setup_data.fg_color) ,GetBValue(setup_data.fg_color) , 0, hFont, NULL, NULL);

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
	time_exam.AddList(__FILE__, __LINE__);  // Xgǉ̎Ԓp2A
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */

	if (fp->check[CONF_IDX_CHKBOX_JOSM_VIEW_AUTO]){
		JOSM_RemoteControl(GPSPOS_JOSM_CONTROL_VIEW, fp, fpip->frame);	
	}
#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */

	return TRUE;
}

//---------------------------------------------------------------------
//		WndProc
//---------------------------------------------------------------------
BOOL func_WndProc( HWND hwnd,UINT message,WPARAM wparam,LPARAM lparam,void *editp,FILTER *fp )
{
	//	TRUEԂƑŜĕ`悳

	FILE_INFO	finfo;
	BOOL ret_val = FALSE;

	switch(message) {
	case WM_FILTER_FILE_OPEN:
		if(fp->exfunc->get_file_info(editp, &finfo)){
			fp->track_e[CONF_IDX_X_POS] = finfo.w;
			fp->track_e[CONF_IDX_Y_POS] = finfo.h;
			work_mem.frame_rate = (double)finfo.video_rate / finfo.video_scale;
			work_mem.flag_set_StartTime_by_uop = 0;
			fp->exfunc->filter_window_update(fp);
		}
		break;
	case WM_FILTER_INIT:
		initialize_dialog(hwnd, fp->dll_hinst);
		break;
	case WM_FILTER_UPDATE:
		onFilterConfUpdate();
		break;
	case WM_COMMAND:
		switch(wparam){
		case MID_FILTER_BUTTON+CONF_IDX_CHKBOX_GPS_FILE:
			onPress_GPS_file_button(hwnd, fp);
			ret_val = TRUE;
			break;
		case MID_FILTER_BUTTON+CONF_IDX_CHKBOX_FONT:
			onPress_font_button(hwnd);
			ret_val = TRUE;
			break;
		case MID_FILTER_BUTTON+CONF_IDX_CHKBOX_FG_COLOR:
			onPress_fg_color_button(hwnd);
			ret_val = TRUE;
			break;
		case MID_FILTER_BUTTON+CONF_IDX_CHKBOX_BORDER_COLOR:
			onPress_border_color_button(hwnd);
			ret_val = TRUE;
			break;
		case MID_FILTER_BUTTON+CONF_IDX_CHKBOX_JOSM_VIEW:
			onPress_JOSM_View_button(fp, editp);
			break;
		case MID_FILTER_BUTTON+CONF_IDX_CHKBOX_JOSM_ADD:
			onPress_JOSM_AddNode_button(fp, editp);
			break;
		}
		break;
	}

	return ret_val;
}

//---------------------------------------------------------------------
//		ݒʏ
//---------------------------------------------------------------------
void initialize_dialog(HWND hwnd, HINSTANCE hinst)
{

}

//---------------------------------------------------------------------
//		GPS File {^̏
//---------------------------------------------------------------------
void onPress_GPS_file_button(HWND hwnd, FILTER *fp)
{
#if !defined(_DEBUG)
	char FileName[MAX_PATH];
	OPENFILENAME ofn;

	memset(FileName, 0, MAX_PATH);
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof (OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.lpstrFilter = TEXT("GPX files (*.gpx)\0*.gpx\0\0");
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = FileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (GetOpenFileName(&ofn)){
		ReadGpxFile_TinyXML(ofn.lpstrFile);
	}
#else /* defined(_DEBUG) */
	// Œt@Cǂ
	ReadGpxFile_TinyXML("test.gpx");
#endif /* defined(_DEBUG) */
}

//---------------------------------------------------------------------
//		Font {^̏
//---------------------------------------------------------------------
void onPress_font_button(HWND hwnd)
{
	LOGFONT lf;
	CHOOSEFONT cf;
	HFONT hFont;

	memset(&cf, 0, sizeof(CHOOSEFONT));

	hFont = CreateFont(setup_data.font_point_size, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH | FF_MODERN, setup_data.font_name);
	GetObject(hFont, sizeof(LOGFONT), &lf);
	cf.lStructSize = sizeof(CHOOSEFONT);
	cf.hwndOwner = hwnd;
	cf.lpLogFont = &lf;
	cf.Flags = CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;
	cf.rgbColors = setup_data.fg_color;
	cf.nFontType = SCREEN_FONTTYPE;

	if (ChooseFont(&cf)){
		setup_data.fg_color = cf.rgbColors;
		strcpy_s(setup_data.font_name, LF_FACESIZE, cf.lpLogFont->lfFaceName);
		setup_data.font_point_size = cf.lpLogFont->lfHeight;
		//		setup_data.text_font = CreateFontIndirect(cf.lpLogFont);
		work_mem.hTextFont = CreateFont(setup_data.font_point_size, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH | FF_MODERN, setup_data.font_name);
	}
}

//---------------------------------------------------------------------
//		Text color {^̏
//---------------------------------------------------------------------
void onPress_fg_color_button(HWND hwnd)
{
	CHOOSECOLOR cc;
	COLORREF CustColors[16];
	cc.lStructSize = sizeof(cc);
	cc.hwndOwner = hwnd;
	cc.hInstance = NULL;
	cc.rgbResult = setup_data.fg_color;
	cc.lpCustColors = CustColors;
	cc.Flags = CC_RGBINIT|CC_FULLOPEN;
	cc.lCustData = NULL;
	cc.lpfnHook = NULL;
	cc.lpTemplateName = NULL;
	
	//J[_CAO\
	if (ChooseColor(&cc)){
		// m肵猋ʊi[
		setup_data.fg_color = cc.rgbResult;
	}
}

//---------------------------------------------------------------------
//		Border color {^̏
//---------------------------------------------------------------------
void onPress_border_color_button(HWND hwnd)
{
	CHOOSECOLOR cc;
	COLORREF CustColors[16];
	cc.lStructSize = sizeof(cc);
	cc.hwndOwner = hwnd;
	cc.hInstance = NULL;
	cc.rgbResult = setup_data.border_color;
	cc.lpCustColors = CustColors;
	cc.Flags = CC_RGBINIT|CC_FULLOPEN;
	cc.lCustData = NULL;
	cc.lpfnHook = NULL;
	cc.lpTemplateName = NULL;
	
	//J[_CAO\
	if (ChooseColor(&cc)){
		// m肵猋ʊi[
		setup_data.border_color = cc.rgbResult;
	}
}

//---------------------------------------------------------------------
//		JOSM view {^̏
//---------------------------------------------------------------------
void onPress_JOSM_View_button(FILTER *fp, void *editp)
{
	JOSM_RemoteControl(GPSPOS_JOSM_CONTROL_VIEW, fp, fp->exfunc->get_frame(editp));
}

//---------------------------------------------------------------------
//		JOSM Add {^̏
//---------------------------------------------------------------------
void onPress_JOSM_AddNode_button(FILTER *fp, void *editp)
{
	JOSM_RemoteControl(GPSPOS_JOSM_CONTROL_ADD, fp, fp->exfunc->get_frame(editp));
}

//---------------------------------------------------------------------
//		̃tB^쎞̏
//---------------------------------------------------------------------
void onfirst_func_proc(){
	work_mem.hTextFont = CreateFont(setup_data.font_point_size, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH | FF_MODERN, setup_data.font_name);

}
//---------------------------------------------------------------------
//		tB^ݒXV̏it[ړȂǂ܂ށj
//---------------------------------------------------------------------
void onFilterConfUpdate(){
}

//---------------------------------------------------------------------
//---------------------------------------------------------------------
//   
//---------------------------------------------------------------------
//		\擾
//---------------------------------------------------------------------
std::string GetFrameString(FILTER *fp,FILTER_PROC_INFO *fpip)
{
	std::string str;
	std::ostringstream ost;
	str = "";
	time_t time;
	time_t time_local;
	struct tm s_time;
	timeval tv;
	double lat, lon;

	// \
	time = setup_data.tvStart.tv_sec + (long)(fpip->frame / work_mem.frame_rate);
	time += fp->track[CONF_IDX_FILEDIFF_H] * 3600 + fp->track[CONF_IDX_FILEDIFF_M] * 60 + fp->track[CONF_IDX_FILEDIFF_S];
	time_local = time + fp->track[CONF_IDX_TIMEDIFF_H] * 3600 + fp->track[CONF_IDX_TIMEDIFF_M] * 60;
	gmtime_s(&s_time, &time_local);

	ost.clear();
	ost << s_time.tm_year+1900 << "-";
	ost << std::setw(2) << std::setfill('0') << (s_time.tm_mon +1) << "-";
	ost << std::setw(2) << std::setfill('0') << s_time.tm_mday << " ";
	ost << std::setw(2) << std::setfill('0') << s_time.tm_hour << ":";
	ost << std::setw(2) << std::setfill('0') << s_time.tm_min << ":";
	ost << std::setw(2) << std::setfill('0') << s_time.tm_sec << "\n";

	// W\
	tv.tv_sec = (long)time;
	tv.tv_usec = 0;
	GetPositionFromTimeval(&tv, &lat, &lon);
	ost << std::setprecision(8) << std::fixed << lat;
	ost << " ";
	ost << std::setprecision(8) << std::fixed << lon;

	str += ost.str();
	return str;
}

//---------------------------------------------------------------------
//	w莞̐ʒu擾
//      tv      [IN]  source time
//      lat     [OUT] estimated latitude
//      lon     [OUT] estimated longitude
//      (ret) true=sucess
//---------------------------------------------------------------------
bool GetPositionFromTimeval (timeval *tv, double *lat, double *lon)
{
	std::list<GPS_PosData>::iterator itr_gps_next;

	*lat = 0.0;
	*lon = 0.0;
	if ((!work_mem.gps_list)||(work_mem.gps_list->size()==0)){
		return false;
	}

	// Xǧ݈ʒuƂ̈ʒůԂɌݎʒuɈړ

	// Xg̈ʒuݎ̏ꍇ̓Xg߂
	while((work_mem.itr_gps_list != work_mem.gps_list->begin())&&
		((*(work_mem.itr_gps_list)).tv.tv_sec > tv->tv_sec)){
		work_mem.itr_gps_list--;
	}
	// Xg̎ݎȌꍇ̓Xgi߂
	itr_gps_next = work_mem.itr_gps_list;
	itr_gps_next++;
	while(((itr_gps_next) != work_mem.gps_list->end())&&
		  ((*itr_gps_next).tv.tv_sec < tv->tv_sec)){
		work_mem.itr_gps_list = itr_gps_next;
		itr_gps_next++;
	}

	// Xg2_Ԃ̊O̎ꍇ́AXgňԋ߂̂gp
	// 傤ǎԂꍇ܂
	if (((work_mem.itr_gps_list == work_mem.gps_list->begin())||
		 ((*work_mem.itr_gps_list).tv.tv_sec >= tv->tv_sec))    ||
		(itr_gps_next == work_mem.gps_list->end())){
			*lat = (*work_mem.itr_gps_list).lat;
			*lon = (*work_mem.itr_gps_list).lon;
			return true;
	}else
	if ((itr_gps_next != work_mem.gps_list->end())&&
		((*itr_gps_next).tv.tv_sec <= tv->tv_sec)){
			*lat = (*itr_gps_next).lat;
			*lon = (*itr_gps_next).lon;
			return true;
	}

	// Xg2_Ԃ̏ꍇ́AXg̋ߖT2ӏʒu
	//	Xc = Xa + (Xb-Xa)*((Tc-Ta)/(Tb-Ta))
	*lat = (*work_mem.itr_gps_list).lat +
		   ((*itr_gps_next).lat - (*work_mem.itr_gps_list).lat)*
		   ((double)(tv->tv_sec-(*work_mem.itr_gps_list).tv.tv_sec)/
		   ((*itr_gps_next).tv.tv_sec-(*work_mem.itr_gps_list).tv.tv_sec));
	*lon = (*work_mem.itr_gps_list).lon +
		   ((*itr_gps_next).lon - (*work_mem.itr_gps_list).lon)*
		   ((double)(tv->tv_sec-(*work_mem.itr_gps_list).tv.tv_sec)/
		   ((*itr_gps_next).tv.tv_sec-(*work_mem.itr_gps_list).tv.tv_sec));
		   
	return true;
}

#define JOSM_WIDE_LON 0.001
#define JOSM_WIDE_LAT 0.001
//---------------------------------------------------------------------
//		JOSM [g䏈
//---------------------------------------------------------------------
bool JOSM_RemoteControl(GPSPOS_JOSM_CONTROL_TYPE type, FILTER *fp, int frame)
{
	// ݎƍW擾AJOSM̈ʒu𓯊
	time_t time;
	timeval tv;
	double lat, lon;
	std::string strCommand;
	std::stringstream ss;

	time = setup_data.tvStart.tv_sec + (long)(frame / work_mem.frame_rate);
	time += fp->track[CONF_IDX_FILEDIFF_H] * 3600 + fp->track[CONF_IDX_FILEDIFF_M] * 60 + fp->track[CONF_IDX_FILEDIFF_S];
	tv.tv_sec = (long)time;
	tv.tv_usec = 0;
	if (GetPositionFromTimeval(&tv, &lat, &lon) == false){
		return false;
	}

	switch(type){
	case GPSPOS_JOSM_CONTROL_VIEW:
		//	strCommand = "zoom?left=135.539645&right=135.539845&top=34.738627&bottom=34.736627";
		ss << std::setprecision(8) << std::fixed;
		ss << "zoom?left=" << lon-JOSM_WIDE_LON;
		ss << "&right=" << lon+JOSM_WIDE_LON;
		ss << "&top=" << lat+JOSM_WIDE_LAT;
		ss << "&bottom=" << lat-JOSM_WIDE_LAT;
		strCommand = ss.str();
		break;
 	case GPSPOS_JOSM_CONTROL_ADD:
		//	strCommand = "add_node?lon=135.539745&lat=34.737627";
		ss << std::setprecision(8) << std::fixed;
		ss << "add_node?lon=" << lon;
		ss << "&lat=" << lat;
		strCommand = ss.str();
		break;
	default:
		return false;
	}

	if (JOSM_RemoteControl(strCommand)){
		return false;
	}
	return true;
}

#define	READBUFFER_SIZE		(32)
bool JOSM_RemoteControl(std::string strCommand)
{
	// ϐ
	HINTERNET			hInternetConnect = NULL;
	HINTERNET			hInternetRequest = NULL;
	std::string			strServer;
	std::string			strObject;
	INTERNET_PORT		nPort;
	std::string			strVerb;
	std::string			strHeaders;
	std::stringstream	ssRead;

	strServer = "127.0.0.1";
	nPort	  = 8111;
	strObject = strCommand;

	DWORD dwFlags = 0;
	dwFlags = INTERNET_FLAG_RELOAD | INTERNET_FLAG_DONT_CACHE;

	// GET
	strVerb		= "GET";
	strHeaders	= "";

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */
	// WinINet̏iɏς݂Ȃ牽Ȃj
	if (NULL == hInternetOpen){
		hInternetOpen = InternetOpen(	"",		// UserAgent
									INTERNET_OPEN_TYPE_PRECONFIG,
									NULL, NULL, 0 );
	}
	if( NULL == hInternetOpen )
	{
		goto LABEL_ERROR;
	}

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */
	// HTTPڑ
	hInternetConnect = InternetConnect(	hInternetOpen,
										strServer.c_str(),
										nPort,
										NULL,
										NULL,
										INTERNET_SERVICE_HTTP,
										0,
										0 );
	if( NULL == hInternetConnect )
	{
		goto LABEL_ERROR;
	}

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */
	// HTTPڑJ
	hInternetRequest = HttpOpenRequest( hInternetConnect,
										strVerb.c_str(),
										strObject.c_str(),
										NULL,
										NULL,
										NULL,
										dwFlags,
										NULL );
	if( NULL == hInternetRequest )
	{
		goto LABEL_ERROR;
	}

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */
	// HTTPvM
	if( !HttpSendRequest(	hInternetRequest,
							strHeaders.c_str(),
							(DWORD)strHeaders.length(),
							NULL, 0 ) )
	{
		goto LABEL_ERROR;
	}

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */
	// HTTPvɑΉXe[^XR[h̎擾
	DWORD dwStatusCode;
	DWORD dwLength = sizeof(dwStatusCode);
	if( !HttpQueryInfo(	hInternetRequest,
						HTTP_QUERY_STATUS_CODE | HTTP_QUERY_FLAG_NUMBER,
						&dwStatusCode,
						&dwLength,
						0 ) )
	{
		goto LABEL_ERROR;
	}
	if( HTTP_STATUS_OK != dwStatusCode )
	{
		goto LABEL_ERROR;
	}

#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */
#if 0
	// HTTPt@Cǂݍ
	char szReadBuffer[READBUFFER_SIZE + 1];
	while( 1 )
	{
		DWORD dwRead = 0;
		if( !InternetReadFile( hInternetRequest, szReadBuffer, READBUFFER_SIZE, &dwRead ) )
		{
			goto LABEL_ERROR;
		}
		if( 0 == dwRead )
		{
			break;
		}
		szReadBuffer[dwRead] = '\0';	// I[u\0v̕t
		size_t length = dwRead + 1;
		LPWSTR	pszWideChar = (LPWSTR)malloc( length * sizeof(WCHAR) );
		MultiByteToWideChar(	CP_UTF8,	// CODE PAGE: UTF-8
								0,
								szReadBuffer,
								-1,
								pszWideChar,
								(int)length );	// UTF-8ANSIɕϊ
		ssRead << pszWideChar;	// Xg[ɗ
		free( pszWideChar );
	}
#endif /* 0 */
#if defined(ENABLE_BENCHMARK_EXAMINATION)
	time_exam.AddList(__FILE__, __LINE__); 
#endif /* defined(ENABLE_BENCHMARK_EXAMINATION) */

	InternetCloseHandle(hInternetRequest);
	InternetCloseHandle(hInternetConnect);
	return true;

LABEL_ERROR:
	InternetCloseHandle(hInternetRequest);
	InternetCloseHandle(hInternetConnect);
	return false;
}

//---------------------------------------------------------------------
//		GPXt@C̓ǂݍ݂Ɖ
//---------------------------------------------------------------------
int ReadGpxFile_TinyXML(std::string strFile)
{
	std::string str_target;
	GPS_PosData gps_data_set;
	tinyxml2::XMLDocument doc;
	tinyxml2::XMLElement *elem_trkpt;
	tinyxml2::XMLElement *elem_time;

	// ߋ̃XgNA
	work_mem.gps_list->clear();

	if (doc.LoadFile( strFile.c_str() ) != 0){
		MessageBox(NULL, "File load error", "", 0);
		return 0;
	}

	elem_trkpt = doc.FirstChildElement( "gpx" );
	if (elem_trkpt != NULL) elem_trkpt = elem_trkpt->FirstChildElement( "trk" );
	if (elem_trkpt != NULL) elem_trkpt = elem_trkpt->FirstChildElement( "trkseg" );
	if (elem_trkpt != NULL) elem_trkpt = elem_trkpt->FirstChildElement( "trkpt" );
	if (elem_trkpt == NULL){
		MessageBox(NULL, "No trkpt in GPX file", "", 0);
		return 0;
	}

	while(elem_trkpt){
		gps_data_set.lon = elem_trkpt->DoubleAttribute( "lon" );
		gps_data_set.lat = elem_trkpt->DoubleAttribute( "lat" );
		elem_time = elem_trkpt->FirstChildElement( "time" );
		str_target = elem_time->GetText();

		// ̉
		ConvertISO8601toTimeval(str_target, &gps_data_set.tv);

		// Add to list
		work_mem.gps_list->push_back(gps_data_set);

		elem_trkpt = elem_trkpt->NextSiblingElement( "trkpt" );
	}

	if(work_mem.gps_list->size() > 0){
		work_mem.itr_gps_list = work_mem.gps_list->begin();

		// GPSJnZbg
		setup_data.tvStart = work_mem.gps_list->front().tv;
	}

	std::stringstream ss;
	ss << "Read complete.\n";
	ss << work_mem.gps_list->size() ;
	ss << " points were imported.";
	MessageBox(NULL, ss.str().c_str(), "", 0);

	return 0;
}

//---------------------------------------------------------------------
//	ISO8601`̎Timevalɕϊ
//      strTime [IN]  source time
//      tv      [OUT] output timeval
//---------------------------------------------------------------------
int ConvertISO8601toTimeval(std::string strTime, timeval *tv)
{
	std::istringstream ss;
	struct tm s_time;

	memset (&s_time, 0, sizeof(s_time));
	memset (tv, 0, sizeof(*tv));

	// year
	ss.clear();
	ss.str(strTime.substr(0,4));
	ss >> s_time.tm_year;
	s_time.tm_year -= 1900;
	strTime = strTime.substr(4);
	if (strTime.length()>0 && strTime[0]=='-'){
		strTime = strTime.substr(1);
	}

	// month
	ss.clear();
	ss.str(strTime.substr(0,2));
	ss >> s_time.tm_mon;
	s_time.tm_mon--;
	strTime = strTime.substr(2);
	if (strTime.length()>0 && strTime[0]=='-'){
		strTime = strTime.substr(1);
	}
	
	// day
	ss.clear();
	ss.str(strTime.substr(0,2));
	ss >> s_time.tm_mday;
	strTime = strTime.substr(2);
	if (strTime.length()>0 && strTime[0]=='T'){
		strTime = strTime.substr(1);
	}
	
	// hour
	ss.clear();
	ss.str(strTime.substr(0,2));
	ss >> s_time.tm_hour;
	strTime = strTime.substr(2);
	if (strTime.length()>0 && strTime[0]==':'){
		strTime = strTime.substr(1);
	}
	
	// minute
	ss.clear();
	ss.str(strTime.substr(0,2));
	ss >> s_time.tm_min;
	strTime = strTime.substr(2);
	if (strTime.length()>0 && strTime[0]==':'){
		strTime = strTime.substr(1);
	}
	
	// second
	ss.clear();
	ss.str(strTime.substr(0,2));
	ss >> s_time.tm_sec;
	strTime = strTime.substr(2);
	if ((strTime.length()>0 && strTime[0]==',')||
	    (strTime.length()>0 && strTime[0]=='.')){
		strTime = strTime.substr(1);

		// milli-second
		ss.clear();
		ss.str(strTime);
		ss >> tv->tv_usec;
		tv->tv_usec *= 1000;
	}
	
	tv->tv_sec = _mkgmtime32(&s_time);

	return 0;
}

//---------------------------------------------------------------------
//	쎞ԒpNX
//---------------------------------------------------------------------

// Jn
void CTimeStampList::StartCount(){
	timelist.clear();
	QueryPerformanceFrequency(&freq);
	QueryPerformanceCounter(&start_count);
}
void CTimeStampList::AddList(std::string file, int line){
	BENCHMARK_TIMESTAMP add_time;
	LARGE_INTEGER current;
	QueryPerformanceCounter(&current);
	add_time.counter.QuadPart = current.QuadPart - start_count.QuadPart;
	add_time.file = file;
	add_time.line = line;
	timelist.push_back(add_time);
}
