#!/usr/bin/perl

# Pangya Course Record Manager
#   util_view.pl
# 
# Copyright(c)2006, T-MZ

use strict;
use vars qw(%data_in);

require './cgi-lib.pl';
require './const.pl';
require './util.pl';
require './config.pl';

$main::PCRM_MODE_VIEW = "view";
$main::PCRM_MODE_EDIT = "edit";
$main::PCRM_MODE_ADD = "add";
$main::PCRM_EDIT_TARGET_SCORE = "score";
$main::PCRM_EDIT_TARGET_PASSWD = "passchg";
$main::PCRM_EDIT_TARGET_DELETE_CONFIRM = "delete_confirm";
$main::PCRM_EDIT_TARGET_DELETE = "delete";
$main::PCRM_EDIT_SCORE_ORDER_CHANGE = "sc_odr_chg";

sub print_html_header {
	print_html_mview_header($conf::view_title);
}

sub print_html_mview_header {
	my ($title);
	$title = shift;

	print ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"><html lang=\"ja-JP\">\n");
	print ("<head><meta http-equiv=\"Content-type\" content=\"text/html; charset=EUC-JP\">\n");
	printf ("<title>%s</title>\n", $title);
	print ("<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\">\n");
	printf ("<link rel=\"STYLESHEET\" type=\"text/css\" href=\"%s/view.css\" ></head>\n",
	        $conf::setting_css_dir);
	print ("<body>\n");
}

sub print_html_footer {
	printf ("<p class=\"copyright\"><a href=\"%s\">%s</a> %s %s</p>", 
	        $CVAL::PCRM_SCRIPT_URI,
	        $CVAL::PCRM_SCRIPT_NAME,
	        $CVAL::PCRM_SCRIPT_VERSION,
	        &util::get_script_copyright_HTML());
	printf ("<p class=\"copyright\">%s</p>", &util::get_pangya_copyright_HTML());
	print ("</body></html>\n");
}

sub print_view {
	# ⡼ɤڤʬ
	if ($data_in{'mode'} eq $main::PCRM_MODE_EDIT)
	{
		&exec_edit_score();
	}
	elsif (($data_in{'mode'} eq $main::PCRM_MODE_ADD)
	       && ($conf::enable_self_useradd))
	{
		&exec_add_member();
	}else{
		&view_main();
	}
}

sub print_view_table_header {
	my ($sortkey, $cs_order_ref, $view_mode, $cs);
	$sortkey = shift;
	$cs_order_ref = shift;
	$view_mode = shift;
	print ("<tr>");
	if($view_mode == $CVAL::VIEW_MODE_EXT_MERGE){
		# ɽ
		print ("<td></td>");
	}
	print ("<td></td>");
	print ("<td></td>");
	print ("<th></th>");
	if($sortkey eq ''){
		print ("<th class=\"sortkey\"></th>");
	}else{
		print ("<th></th>");
	}
	foreach $cs (@$cs_order_ref){
		if($cs eq $sortkey){
			printf ("<th class=\"sortkey\">%s</th>", $CVAL::cs_sname_list{$cs});
		}else{
			printf ("<th>%s</th>", $CVAL::cs_sname_list{$cs});
		}
	}
	if(($view_mode == $CVAL::VIEW_MODE_LOCAL) &&
	   ($conf::enable_view_comment_max > 0)){
		printf ("<th>%s</th>", $CVAL::PCRM_COMMENT);
	}
	print ("</tr>");
}

# ꤵ줿ʬHIDDENȤƽ
sub print_view_general {
	my ($except);
	$except = shift;

	if($except != $CVAL::PCRM_FORM_VIEW_EMPHASIS_DATE){
		my ($recent, @rank_range, $rank_r_idx);
		$recent = get_recent_range();
		@rank_range = get_rank_range();
		printf ("<div><input type=\"hidden\" name=\"recent\" value=\"%s\"></div>",
		        $recent);
		for($rank_r_idx=0; $rank_r_idx<=$#rank_range; $rank_r_idx++){
			printf ("<div><input type=\"hidden\" name=\"r%d\" value=\"%d\"></div>",
			        $rank_r_idx, $rank_range[$rank_r_idx]);
		}
	}
	if($except != $CVAL::PCRM_FORM_VIEW_EMPHASIS_STRONG){
		my (@strong_weak_range, $strong_weak_r_idx);
		@strong_weak_range = get_strong_weak_range();
		for($strong_weak_r_idx=0; $strong_weak_r_idx<=$#strong_weak_range; $strong_weak_r_idx++){
			printf ("<div><input type=\"hidden\" name=\"s%d\" value=\"%d\"></div>",
			        $strong_weak_r_idx, $strong_weak_range[$strong_weak_r_idx]);
		}
	}
	if(($except != $CVAL::PCRM_FORM_VIEW_EMPHASIS_DATE)&&
	   ($except != $CVAL::PCRM_FORM_VIEW_EMPHASIS_STRONG)){
		printf ("<div><input type=\"hidden\" name=\"emphasis_type\" value=\"%s\"></div>",
		        $data_in{"emphasis_type"});
	}
	if($except != $CVAL::PCRM_FORM_VIEW_SCORE_SORTKEY){
		printf ("<div><input type=\"hidden\" name=\"sortkey\" value=\"%s\"></div>", $data_in{"sortkey"});
	}
	if($except != $CVAL::PCRM_FORM_VIEW_COURSE_TARGET_USER){
		printf ("<div><input type=\"hidden\" name=\"cs_target_usr\" value=\"%s\"></div>", $data_in{"cs_target_usr"});
	}
}

sub print_view_sortkey_change {
	my ($sortkey, $cs_order_ref, $view_mode, $cs);
	$sortkey = shift;
	$cs_order_ref = shift;
	$view_mode = shift;

	print ("<tr><td></td>");
	if($view_mode == $CVAL::VIEW_MODE_EXT_MERGE){
		print ("<td></td>");
	}
	print ("<td class=\"button\">");
	if($data_in{"cs_target_usr"} ne ""){
		print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
		print_view_general($CVAL::PCRM_FORM_VIEW_COURSE_TARGET_USER);
		print ("<div><input type=\"submit\" value=\"\"></div></form>");
	}
	print ("</td><td></td>");
	print ("<td class=\"button\">");
	if($sortkey ne ''){
		print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
		print_view_general($CVAL::PCRM_FORM_VIEW_SCORE_SORTKEY);
		print ("<div><input type=\"submit\" value=\"\"></div></form>");
	}
	print ("</td>");
	foreach $cs (@$cs_order_ref){
		print ("<td class=\"button\">");
		if($cs ne $sortkey){
			print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
			print_view_general($CVAL::PCRM_FORM_VIEW_SCORE_SORTKEY);
			printf ("<div><input type=\"hidden\" name=\"sortkey\" value=\"%s\" ></div>",
			        $cs);
			print ("<div><input type=\"submit\" value=\"\"></div></form>");
		}
		print ("</td>");
	}
	print ("</tr>");
}

sub get_recent_range {
	my ($recent);
	$recent = $data_in{"recent"};
	if($recent eq ""){
		$recent = $conf::recent_days;
	}
	return $recent;
}

sub get_rank_range {
	my ($rank, $key, $i, $rank_max, @rank_range);
	
	for( $i=0; $i <= $#conf::rank_range; $i++){
		$key = "r" . $i;
		$rank_max = $data_in{$key};
		if($rank_max eq ""){
			$rank_max = $conf::rank_range[$i];
		}
		if($rank_max < 1){
			$rank_max = 1;
		}
		$rank_range[$i] = $rank_max;
	}
	return @rank_range;
}

sub get_strong_weak_range {
	my ($rank, $key, $i, $rank_max, @rank_range);
	
	for( $i=0; $i <= $#conf::strong_weak_range; $i++){
		$key = "s" . $i;
		$rank_max = $data_in{$key};
		if($rank_max eq ""){
			$rank_max = $conf::strong_weak_range[$i];
		}
		if($rank_max < 1){
			$rank_max = 1;
		}
		$rank_range[$i] = $rank_max;
	}
	return @rank_range;
}

sub get_cs_order_by_target_user {
	my ($user, $score_ref, @cs_order);
	$user = shift;
	$score_ref = shift;
	
	if($user eq ""){
		@cs_order = @conf::setting_cs_odr;
	}else{
		@cs_order = sort { $$score_ref{$user}{$a}{SCORE} <=>
		                   $$score_ref{$user}{$b}{SCORE} }
		                   (@conf::setting_cs_odr);
	}
	return @cs_order;
}

sub get_cs_order_by_target_score {
	my ($user, $score_ref, @cs_order);
	$user = shift;
	$score_ref = shift;
	
	if($user eq ""){
		@cs_order = @conf::setting_cs_odr;
	}else{
		@cs_order = sort { $$score_ref{$a}{SCORE} <=>
		                   $$score_ref{$b}{SCORE} }
		                   (@conf::setting_cs_odr);
	}
	return @cs_order;
}

sub print_view_change {
	my ($emphasis_type);
	my ($recent, $i, @rank_range, @strong_weak_range, $add_str);
	$emphasis_type = shift;
	$recent = get_recent_range();
	@rank_range = get_rank_range();
	@strong_weak_range = get_strong_weak_range();
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	# ǥե
	if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_DATE){
		print_view_general($CVAL::PCRM_FORM_VIEW_EMPHASIS_DATE);
	}else{
		print_view_general($CVAL::PCRM_FORM_VIEW_EMPHASIS_STRONG);
	}
	# 1
	printf ("<table summary=\"view-change\"><tr>");
	printf ('<td><select name="emphasis_type" size="2" onChange="submit();">');
	if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_DATE){
		$add_str = ' selected';
	}else{
		$add_str = '';
	}
	printf ('<option value="%d"%s>Ƕι</option>',
	        $CVAL::VIEW_EMPHASYS_MODE_DATE, $add_str);
	if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_STRONG){
		$add_str = ' selected';
	}else{
		$add_str = '';
	}
	printf ('<option value="%d"%s>ա</option>',
	        $CVAL::VIEW_EMPHASYS_MODE_STRONG, $add_str);
	printf ('</select></td>');
	if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_DATE){
		printf ("<td class=\"recent\">Ƕ%dι</td>",
		        $recent);
		if($rank_range[0] > 1){
			printf ("<td><span class=\"rank1\">1%d</span></td>",
			        $rank_range[0]);
		}else{
			printf ("<td><span class=\"rank1\">1</span></td>");
		}
		for($i=1; $i <= $#rank_range; $i++){
			printf ("<td><span class=\"rank%d\">%d</span></td>",
			        $i+1, $rank_range[$i]);
		}
	}else{
		if($strong_weak_range[0] > 1){
			printf ("<td class=\"strong1\">[ե]1%d</td>",
			        $strong_weak_range[0]);
		}else{
			printf ("<td class=\"strong1\">[ե]1</td>");
		}
		for($i=1; $i <= $#strong_weak_range; $i++){
			printf ("<td class=\"strong%d\">%d</td>",
			        $i+1, $strong_weak_range[$i]);
		}
		for($i=$#strong_weak_range; $i >= 1; $i--){
			printf ("<td class=\"weak%d\">%d̡</td>",
			        $i+1, $strong_weak_range[$i]);
		}
		if($strong_weak_range[0] > 1){
			printf ("<td class=\"weak1\">%d1[ꥳ]</td>",
			        $strong_weak_range[0]);
		}else{
			printf ("<td class=\"weak1\">1[ꥳ]</td>");
		}
	}
	printf ("</tr>\n");
	# 2
	printf ("<tr>");
	printf ("<td class=\"button\"><input type=\"submit\" value=\"ɽѹ\" ></td>");
	if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_DATE){
		printf ("<td><input class=\"target\" type=\"text\" name=\"recent\" size=\"3\" value=\"%s\"></td>",
		        $recent);
		for($i=0; $i <= $#rank_range; $i++){
			printf ("<td><input class=\"target\" type=\"text\" name=\"r%d\" size=\"2\" value=\"%d\"></td>",
			        $i, $rank_range[$i]);
		}
	}else{
		for($i=0; $i <= $#strong_weak_range; $i++){
			printf ("<td><input class=\"target\" type=\"text\" name=\"s%d\" size=\"2\" value=\"%d\"></td>",
			        $i, $strong_weak_range[$i]);
		}
	}
	printf ("</tr></table>");
	printf ("</form>");
}

# ɽ䶯ĴɽѤν
sub make_rank_data {
	my ($users_ref, $sortkey, $score_ref, $show_order_ref, $score_cs_ref);
	$users_ref = shift;      # [IN] 桼̾ꥹ
	$sortkey = shift;        # [IN] оݥ
	$score_ref = shift;      # [IN] ꥹ
	$show_order_ref = shift; # [OUT]ɽ¤ؤ桼ꥹ
	$score_cs_ref = shift;   # [OUT]ƥǥ¤٤
	
	my ($user, $cs, @show_order, %scores_cs);
	foreach $user (@$users_ref){
		my ($total, $tscore, @show_order_seg);
		$total = 0;
		if($sortkey eq ''){
			# פ˥Ȥ
			foreach $cs (@CVAL::cs_list){
				$tscore = $$score_ref{$user}{$cs}{SCORE};
				if($tscore < $CVAL::PCRM_NO_RECORD_VAL_MIN){
					$total += $tscore;
				}
			}
			$show_order_seg[0] = $total;
			$show_order_seg[1] = $user;
			push (@show_order, \@show_order_seg);
		}else{
			# ȥ˥Ȥ
			my ($tscore);
			$tscore = $$score_ref{$user}{$sortkey}{SCORE};
			if($tscore < $CVAL::PCRM_NO_RECORD_VAL_MIN){
				$show_order_seg[0] = $tscore;
			}else{
				$show_order_seg[0] = $CVAL::PCRM_NO_RECORD_VAL;
			}
			$show_order_seg[1] = $user;
			push (@show_order, \@show_order_seg);
		}
		foreach $cs (@conf::setting_cs_odr){
			# ȤνȽѥ󥯰ɲ
			push (@{$scores_cs{$cs}}, $$score_ref{$user}{$cs}{SCORE});
		}
	}
	# оݥΥǾ祽
	@show_order = sort{ $$a[0] <=> $$b[0] } @show_order;
	foreach $cs (@conf::setting_cs_odr){
		# Ƚѥ󥯰򾺽祽
		@{$scores_cs{$cs}} = sort { $a <=> $b } (@{$scores_cs{$cs}});
	}
	@$show_order_ref = @show_order;
	%$score_cs_ref = %scores_cs;
}

# к
sub make_deviation_data {
	my ($users_ref, $score_ref, $deviation_ref);
	my (%sd_mean_cs, %deviation_data);
	$users_ref = shift;      # [IN] 桼̾ꥹ
	$score_ref = shift;      # [IN] ꥹ
	$deviation_ref = shift;  # [OUT]к
	
	my ($user, $cs, %scores_cs);
	# ɸкη׻
	foreach $cs (@CVAL::cs_list){
		my (@cs_scores, @sd_mean);
		foreach $user (@$users_ref){
			# ϿΥǡΤɲ
			my ($tscore);
			$tscore = $$score_ref{$user}{$cs}{SCORE};
			if($tscore < $CVAL::PCRM_NO_RECORD_VAL_MIN){
				push (@cs_scores, $tscore);
			}
		}
		# ʿѡɸк
		util::get_mean_and_sd(\@cs_scores, \$sd_mean[0], \$sd_mean[1]);
		$sd_mean_cs{$cs}{MEAN} = @sd_mean[0];
		$sd_mean_cs{$cs}{SD} = @sd_mean[1];
	}
	# ϿȤкͤη׻
	#  кͤʰײ׻ͤ羮ϿͤƱ
	foreach $user (@$users_ref){
		my ($total, $tscore, %deviation_seg);
		$total = 0;
		foreach $cs (@CVAL::cs_list){
			$tscore = $$score_ref{$user}{$cs}{SCORE};
			if($tscore < $CVAL::PCRM_NO_RECORD_VAL_MIN){
				# Ͽ
				if($sd_mean_cs{$cs}{SD} > 0){
					# ɸк0ǤʤΤкͤ
					$deviation_data{$user}{$cs}{SET} = 1;
					$deviation_data{$user}{$cs}{STDEV} = ($tscore - $sd_mean_cs{$cs}{MEAN}) / $sd_mean_cs{$cs}{SD};
				}else{
					$deviation_data{$user}{$cs}{SET} = 0;
				}
			}else{
				$deviation_data{$user}{$cs}{SET} = 0;
			}
		}
	}
	%$deviation_ref = %deviation_data;
}

sub view_main {
	my($result, %score);
	$result = util::get_score_list(\%score);
	printf("<p>%s</p>", $conf::view_title);
	show_edit_mode_button ();
	if($result == $CVAL::PCRM_RESULT_OK){
		view_table(\%score, $CVAL::VIEW_MODE_LOCAL);
	}else{
		print ("<p>եΥ˼Ԥޤ</p>");
	}
	show_edit_mode_button ();
	printf("<p>%s</p>", $conf::view_comment);
}

sub view_table {
	my ($score_ref, $view_mode);
	$score_ref = shift;
	$view_mode = shift;

	my($result, $lscore, @users, @show_order, $current);

	$current = time();
	my ($user, $cs, $order, $index, $rank, $prev, $sort_target);
	my (%scores_cs, $sortkey, @rank_range);
	my ($cs_target_user, @cs_order);
	my ($emphasis_type, @strong_weak_range);
	my (%deviation);
	@users = keys %$score_ref;
	$sortkey = $data_in{"sortkey"};
	$cs_target_user = $data_in{"cs_target_usr"};
	$emphasis_type = $data_in{"emphasis_type"};
	@rank_range = get_rank_range();
	@strong_weak_range = get_strong_weak_range();
	@cs_order = get_cs_order_by_target_user($cs_target_user, \%$score_ref);
	if(($emphasis_type < $CVAL::VIEW_EMPHASYS_MODE_MIN)||
	   ($emphasis_type < $CVAL::VIEW_EMPHASYS_MODE_MAX)){
		# Ĵ⡼꤬ʤդǶĴ
		$emphasis_type = $CVAL::VIEW_EMPHASYS_MODE_DATE;
	}

	print_view_change($emphasis_type);
	printf ("<table summary=\"score-list\"><tbody>");
	print_view_sortkey_change($sortkey, \@cs_order, $view_mode);
	print_view_table_header($sortkey, \@cs_order, $view_mode);
	make_rank_data (\@users, $sortkey, \%$score_ref, \@show_order, \%scores_cs);
	if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_STRONG){
		make_deviation_data (\@users, \%$score_ref, \%deviation);
	}
	$index = 1;
	$rank = 1;
	$prev = -1000;
	foreach $order (@show_order){
		my (@strong_weak_order, $valid_count);
		# 
		$user = $$order[1];
		my ($total, $tscore);
		$total = 0;
		$valid_count = 0;
		foreach $cs (@CVAL::cs_list){
			$tscore = $$score_ref{$user}{$cs}{SCORE};
			if($tscore < $CVAL::PCRM_NO_RECORD_VAL_MIN){
				$total += $tscore;
				$valid_count++;
			}
		}
		$sort_target = $$order[0];
		if($sort_target != $prev){
			$rank = $index;
			$prev = $sort_target;
		}
		if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_STRONG){
			foreach $cs (@CVAL::cs_list){
				if($deviation{$user}{$cs}{SET} != 0){
					push( @strong_weak_order, $deviation{$user}{$cs}{STDEV});
				}
			}
			# դʤΡкͤΡˤˤʤ褦˥
			@strong_weak_order = sort { $a <=> $b } (@strong_weak_order);
		}
		# ɽ
		printf ("<tr>");
		if($view_mode == $CVAL::VIEW_MODE_EXT_MERGE){
			printf ("<td>%s</td>", $$score_ref{$user}{SITE});
		}
		printf ("<td>%s</td>", util::get_replaced_name_with_icon(util::get_substr_euc($user,
		                       $CVAL::PCRM_MEMBER_NAME_MAX_LENGTH)) );
		print ("<td class=\"button\">");
		if($user ne $cs_target_user){
			print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
			print_view_general($CVAL::PCRM_FORM_VIEW_COURSE_TARGET_USER);
			printf ("<div><input type=\"hidden\" name=\"cs_target_usr\" value=\"%s\" ></div>",
			        util::get_encoded_html($user));
			print ("<div><input type=\"submit\" value=\"\"></div></form>");
		}
		print ("</td>");
		printf ("<th>%d</th>", $rank);
		printf ("<th>%d</th>", $total);
		foreach $cs (@cs_order){
			$tscore = $$score_ref{$user}{$cs}{SCORE};
			if($tscore < $CVAL::PCRM_NO_RECORD_VAL_MIN){
				if($emphasis_type == $CVAL::VIEW_EMPHASYS_MODE_DATE){
					# դǶĴ
					my ($rank_r_idx);
					if($$score_ref{$user}{$cs}{MOD} >
					   $current - get_recent_range()*(60*60*24)){
						printf ("<td class=\"recent\">");
					}else{
						printf ("<td>");
					}
					for($rank_r_idx=0; $rank_r_idx<=$#rank_range; $rank_r_idx++){
						if($tscore <= @{$scores_cs{$cs}}[$rank_range[$rank_r_idx]-1]){
							printf ("<span class=\"rank%d\">%d</span>",
							        $rank_r_idx+1, $tscore);
							last;
						}
					}
					if($rank_r_idx > $#rank_range){
						printf ("%d", $tscore);
					}
					printf ("</td>");
				}else{
					# աǶĴ
					my ($strong_weak_r_idx, $stscr);
					$stscr = $deviation{$user}{$cs}{STDEV};
					for($strong_weak_r_idx=0; $strong_weak_r_idx<=$#strong_weak_range; $strong_weak_r_idx++){
						my ($st_index, $wk_index);
						if($strong_weak_range[$strong_weak_r_idx] > $valid_count){
							# ϰϳ˥ʤ褦˰Ĵ
							$st_index = $valid_count-1;
							$wk_index = 0;
						}else{
							$st_index = $strong_weak_range[$strong_weak_r_idx]-1;
							$wk_index = $#strong_weak_order - ($strong_weak_range[$strong_weak_r_idx]-1);
						}
						if($stscr <= @strong_weak_order[$st_index]){
							# 
							if( $stscr < @strong_weak_order[util::round_up(($valid_count-1)/2)]){
								# ʬкͤɤ
								printf ('<td class="strong%d">', $strong_weak_r_idx+1);
								last;
							}
						}
						if($stscr >= @strong_weak_order[$wk_index]){
							# 
							if( $stscr > @strong_weak_order[util::round_down(($valid_count-1)/2)]){
								# ʬкͤ갭
								printf ('<td class="weak%d">', $strong_weak_r_idx+1);
								last;
							}
						}
					}
					if($strong_weak_r_idx > $#strong_weak_range){
						printf ('<td>');
					}
					printf ("%d", $tscore);
#					printf ("(%.2f)", $stscr);
					printf ("</td>");
				}
			}else{
				printf ("<td>%s</td>", "**");
			}
		}
		if(($view_mode == $CVAL::VIEW_MODE_LOCAL) &&
		   ($conf::enable_view_comment_max > 0)){
			printf ("<td>%s</td>", 
			        util::get_replaced_name_with_icon(
			        	util::get_substr_euc($$score_ref{$user}{COMMENT}, $conf::enable_view_comment_max))
			        );
		}
		printf ("</tr>\n");
		if($index % $conf::PCRM_TABLE_HEADER_INTERVAL == 0){
			print_view_table_header($sortkey, \@cs_order, $view_mode);
		}
		$index++;
	}
	if($index % $conf::PCRM_TABLE_HEADER_INTERVAL != 1){
		print_view_table_header($sortkey, \@cs_order, $view_mode);
	}
	printf ("</tbody></table>");
}

sub print_logout_button {
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<div><input type=\"submit\" value=\"\"></div></form>\n");

}

sub print_change_menu_button {
	my($account, $passwd);
	$account = $data_in{'account'};
	$passwd = $data_in{'pass'};
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_EDIT\" ></div>");
	printf ("<div><input type=\"hidden\" name=\"account\" value=\"%s\" ></div>", util::get_encoded_html($account));
	printf ("<div><input type=\"hidden\" name=\"pass\" value=\"%s\" ></div>", util::get_encoded_html($passwd));
	print ("<div><input type=\"submit\" value=\"⡼ɲ̤\"></div></form>\n");
}

sub show_edit_mode_button {
	print ("<table summary=\"edit\"><tr>");
	print ("<td class=\"button\"><form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_EDIT\" ></div>");
	print ("<div><input type=\"submit\" value=\"ʬξѹ\"></div></form></td>");
	if ($conf::enable_self_useradd){
		print ("<td class=\"button\"><form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
		print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_ADD\" ></div>");
		print ("<div><input type=\"submit\" value=\"Сɲ\"></div></form></td>");
	}
	print ("</tr></table>\n");
}

sub exec_edit_score
{
	# ⡼ɤڤʬ
	if ($data_in{'account'} eq '')
	{
		&print_edit_login();
	}else{
		&exec_edit_login_show();
	}
}

# 
sub print_edit_login
{
	my(@account_list, $result);
	my($account);
	
	{
		print ("<p>ʬξԽ</p>");
		print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>");
		print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_EDIT\" ></div>");
		print ("<div>С̾<input class=\"target\" type=\text\ name=\"account\" value=\"\" size=\"20\" ></div>");
		print ("<div>ѥ<input class=\"target\" type=\"password\" name=\"pass\" value=\"\" size=\"20\" ></div>");
		print ("<div><input type=\"submit\" value=\"\"></div></form>\n");
		print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
		print ("<div><input type=\"submit\" value=\"ɽ\"></div></form>");
	}

}

# ľܥɽ
sub print_login_default_button
{
	my($account, $passwd);
	$account = $data_in{'account'};
	$passwd = $data_in{'pass'};

	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_EDIT\" ></div>");
	printf ("<div><input type=\"hidden\" name=\"account\" value=\"%s\" ></div>", util::get_encoded_html($account));
	printf ("<div><input type=\"hidden\" name=\"pass\" value=\"%s\" ></div>", util::get_encoded_html($passwd));
	print ("<div><input type=\"submit\" value=\"̤\"></div></form>\n");
}

# ǧ
sub exec_edit_login_show
{
	my ($account, $pass);
	$account = $data_in{'account'};
	$pass = $data_in{'pass'};

	my ($result);
	$result = util::exec_auth($account, $pass);
	if($result != $CVAL::PCRM_RESULT_OK){
		print("<p>˼Ԥޤ</p>");
		print_login();
	}
	
	exec_edit_need_auth_proc();
}

# ǧڸν
sub exec_edit_need_auth_proc
{
	if ($data_in{'edit'} eq $main::PCRM_EDIT_TARGET_PASSWD)
	{
		&exec_chg_pass_show();
	}
	elsif ($data_in{'edit'} eq $main::PCRM_EDIT_TARGET_SCORE)
	{
		&exec_update_score_show();
	}
	elsif ($data_in{'edit'} eq $main::PCRM_EDIT_TARGET_DELETE_CONFIRM)
	{
		&exec_delete_member_confirm_show();
	}
	elsif ($data_in{'edit'} eq $main::PCRM_EDIT_TARGET_DELETE)
	{
		&exec_delete_member_show();
	}
	else
	{
		&print_show_change_view();
	}
}

# ꤵ줿ʬHIDDENȤƽ
sub print_edit_general {
	my ($except, $account, $passwd);
	$except = shift;
	$account = shift;
	$passwd = shift;

	# ɬܹܤν
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_EDIT\" ></div>");
	printf ("<div><input type=\"hidden\" name=\"account\" value=\"%s\" ></div>", util::get_encoded_html($account));
	printf ("<div><input type=\"hidden\" name=\"pass\" value=\"%s\" ></div>", util::get_encoded_html($passwd));
	if($except != $CVAL::PCRM_FORM_EDIT_COURSE_ORDER_TYPE){
		printf ("<div><input type=\"hidden\" name=\"cs_target_usr\" value=\"%s\" ></div>", $data_in{'cs_target_usr'});
	}
}

sub print_show_change_view
{
	my($account, $passwd);
	$account = $data_in{'account'};
	$passwd = $data_in{'pass'};
	my(%score, $result, $cs, $cs_target_usr);

	$cs_target_usr = $data_in{'cs_target_usr'};
	$result = util::get_target_user_data($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		printf("<p>С[%s]Υǡ˼Ԥޤ</p>", util::get_encoded_html($account));
		print_change_menu_button();
		return;
	}
	printf ("<p>⡼ [%s]</p>", util::get_encoded_html($account));
	print ("<p></p>");

	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print_edit_general($CVAL::PCRM_FORM_EDIT_COURSE_ORDER_TYPE,
		               $account, $passwd);
	printf ("<div><input type=\"hidden\" name=\"edit\" value=\"%s\" ></div>", $main::PCRM_EDIT_SCORE_ORDER_CHANGE);
	if($cs_target_usr eq ""){
		printf ("<div><input type=\"hidden\" name=\"cs_target_usr\" value=\"%s\" ></div>",
		        util::get_encoded_html($account));
		printf ("<div><input type=\"submit\" value=\"򥹥ɽ\"></div></form>\n");
	}else{
		printf ("<div><input type=\"submit\" value=\"ٽɽ\"></div></form>\n");
	}

	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<table summary=\"score\"><tbody>");
	print ("<tr><th></th><th>̾</th><th></th><th>ѹ</th><th>󹹿</th></tr>");
	foreach $cs (get_cs_order_by_target_score($cs_target_usr, \%score)){
		my ($mod_time, $c_score);
		$c_score = 0+$score{$cs}{SCORE};
		if($c_score >= $CVAL::PCRM_NO_RECORD_VAL_MIN){
			$c_score = "Ͽʤ"
		}
		$mod_time = $score{$cs}{MOD};
		if($mod_time == 0){
			$mod_time = "̤";
		}else{
			my($sec, $min, $hour, $mday, $mon, $year);
			($sec, $min, $hour, $mday, $mon, $year, undef, undef, undef) = localtime($mod_time);
			$mod_time = sprintf("%04d/%02d/%02d %02d:%02d",
			                    1900+$year, 1+$mon, $mday, $hour, $min);
		}
		printf ("<tr><th>[%s]</th>", $CVAL::cs_sname_list{$cs});
		printf ("<td>%s</td>", $CVAL::cs_lname_list{$cs});
		printf ("<td>%s</td>", $c_score);
		printf ("<td><input class=\"target\" type=\"text\" name=\"%s\" value=\"\" size=\"3\"></td>", $CVAL::cs_sname_list{$cs});
		printf ("<td>%s</td>", $mod_time);
		printf ("</tr>");
	}
	print ("</tbody></table>\n");
	if($conf::enable_view_comment_max > 0){
		print ("<table summary=\"comment\"><tbody>");
		printf ("<tr><th rowspan=\"3\">%s</th>", $CVAL::PCRM_COMMENT);
		printf ("<th></th><td>%s</td><td></td></tr>", util::get_encoded_html($score{COMMENT}));
		printf ("<tr><th>ѹ</th><td><input class=\"target\" type=\"text\" name=\"comment\" value=\"%s\" size=\"%d\"></td>",
		        util::get_encoded_html($score{COMMENT}), $conf::enable_view_comment_max*2);
		printf ("<td>%dʸ</td></tr>", $conf::enable_view_comment_max);
		print ("</tbody></table>");
	}
	printf ("<div>ϿȤ%dϿȡϿʤޤ</div>", $CVAL::PCRM_NO_RECORD_VAL);
	print ("<div><input class=\"target\" type=\"checkbox\" name=\"modkeep\" value=\"1\" >Ѥ˵Ͽ</div>");
	print_edit_general($CVAL::PCRM_FORM_EDIT_SCORE,
		               $account, $passwd);
	printf ("<div><input type=\"hidden\" name=\"edit\" value=\"%s\" ></div>", $main::PCRM_EDIT_TARGET_SCORE);
	if($conf::enable_view_comment_max > 0){
		print ("<div><input type=\"submit\" value=\"ȹ\"></div></form>\n");
	}else{
		print ("<div><input type=\"submit\" value=\"\"></div></form>\n");
	}

	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<div>ѥ<input class=\"target\" type=\"password\" name=\"newpass1\" size=\"20\" >ȾѱѿȰε_!#\$\%&amp;'()+-*/=~{}?@.ˤΤ߻ѲǽǤ</div>");
	print ("<div>ѥ<input class=\"target\" type=\"password\" name=\"newpass2\" size=\"20\" >ʺϡ</div>");
	print_edit_general($CVAL::PCRM_FORM_EDIT_PASSWORD,
		               $account, $passwd);
	printf ("<div><input type=\"hidden\" name=\"edit\" value=\"%s\" ></div>", $main::PCRM_EDIT_TARGET_PASSWD);
	print ("<div><input type=\"submit\" value=\"ѥѹ\"></div></form>\n");

	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print_edit_general($CVAL::PCRM_FORM_EDIT_DELETE,
		               $account, $passwd);
	printf ("<div><input type=\"hidden\" name=\"edit\" value=\"%s\" ></div>", $main::PCRM_EDIT_TARGET_DELETE_CONFIRM);
	printf ("<div><input type=\"submit\" value=\"С[%s]ξƺ\"></div></form>\n", util::get_encoded_html($account));

	print_logout_button();
}

# ѥɹ
sub exec_chg_pass_show
{
	my($account, $pass1, $pass2);
	$account = $data_in{'account'};
	$pass1 = $data_in{'newpass1'};
	$pass2 = $data_in{'newpass2'};

	my(%score, $result);

	if ($pass1 ne $pass2){
		printf("<p>ѥɤפƤޤ</p>");
		print_change_menu_button();
		return;
	}

	$result = util::get_target_user_data($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		printf("<p>С[%s]Υǡ˼Ԥޤ</p>", util::get_encoded_html($account));
		print_change_menu_button();
		return;
	}
	$score{PASSWD} = util::get_encrypted_passwd($pass1);

	$result = util::set_target_user_data($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		printf("<p>С[%s]Υǡ˼Ԥޤ</p>", util::get_encoded_html($account));
		print_change_menu_button();
		return;
	}

	printf("<p>ѥɤ򹹿ޤöȤƤ</p>");
	print_logout_button();
}

# 
sub exec_update_score_show
{
	my($account, $modkeep, $comment);
	$account = $data_in{'account'};
	$modkeep = $data_in{'modkeep'};
	$comment = $data_in{'comment'};

	my(%score, $result, $cs, $comment_temp);

	$comment_temp = util::get_substr_euc($comment, $conf::enable_view_comment_max);
	# ե˱ƶФʸϺ
	$comment_temp =~ s/[\t]//g;
	$score{COMMENT} = $comment_temp;

	$result = util::get_target_user_data($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		printf("<p>С[%s]Υǡ˼Ԥޤ</p>", util::get_encoded_html($account));
		return;
	}
	foreach $cs (@CVAL::cs_list){
		my ($newscore);
		$newscore = $data_in{$CVAL::cs_sname_list{$cs}};
		if($newscore ne ''){
			$score{$cs}{SCORE} = $newscore;
			if($modkeep eq ''){
				$score{$cs}{MOD} = time();
			}
		}
	}
	$score{COMMENT} = util::get_substr_euc($comment, $conf::enable_view_comment_max);

	$result = util::set_target_user_data($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		printf("<p>С[%s]Υǡ˼Ԥޤ</p>", util::get_encoded_html($account));
		return;
	}

	printf("<p>򹹿ޤ</p>");
	print_login_default_button();
	print_logout_button();
}

# Сǧ
sub exec_delete_member_confirm_show {
	my ($account, $pass);
	$account = $data_in{'account'};
	$pass = $data_in{'pass'};
	printf ("<p>С[%s]κǧ</p>", util::get_encoded_html($account));
	print ("<p>ٺϸ᤻ޤ󡣤ǤϺܥ򲡤Ƥ</p>");
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_EDIT\" ></div>");
	printf ("<div><input type=\"hidden\" name=\"account\" value=\"%s\" ></div>", util::get_encoded_html($account));
	printf ("<div><input type=\"hidden\" name=\"pass\" value=\"%s\" ></div>", $pass);
	print ("<div><input type=\"hidden\" name=\"edit\" value=\"$main::PCRM_EDIT_TARGET_DELETE\" ></div>");
	print ("<div><input type=\"submit\" value=\"\"></div></form>\n");

	print_change_menu_button();
	print_logout_button();
}

# С
sub exec_delete_member_show {
	my ($account, $pass, $result);
	$account = $data_in{'account'};

	$result = util::delete_target_user_data($account);

	if($result == $CVAL::PCRM_RESULT_OK){
		printf("<p>С [%s] ޤ</p>", util::get_encoded_html($account));
	}else{
		print ("<p>СեΥ˼Ԥޤ</p>");
		print_change_menu_button();
	}
	print_logout_button();
	return;
}


# ɲ
sub exec_add_member {
	if ($data_in{'account'} eq "")
	{
		&print_edit_account_add ();
	}
	else{
		&exec_edit_account_add_show ();
	}
}

sub print_edit_account_add{
	print ("<p>С̾ˤϡʸʤɤϻѤǤޤ󡣥ѥɤˤϡȾѱѿȰε_!#\$\%&'()+-*/=~{}?@.ˤΤ߻ѲǽǤ</p>");
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_MODE_ADD\" ></div>");
	print ("<div>С<input class=\"target\" type=\"text\" name=\"account\" value=\"\" size=\"18\" ></div>");
	print ("<div>ѥ<input class=\"target\" type=\"password\" name=\"pass1\" value=\"\" size=\"12\" ></div>");
	print ("<div>ѥ<input class=\"target\" type=\"password\" name=\"pass2\" value=\"\" size=\"12\" >ʺϡ</div>");
	print ("<div><input type=\"submit\" value=\"ɲ\"></div></form>\n");
}

# Ȥɲ
sub exec_edit_account_add_show{
	my ($account, $pass1, $pass2, $result, $added_account);

	$account = $data_in{'account'};
	$pass1 = $data_in{'pass1'};
	$pass2 = $data_in{'pass2'};

	if ($pass1 ne $pass2){
		printf("<p>ѥɤפƤޤ</p>");
		return;
	}

	$result = util::account_add(\$added_account, $account, $pass1);
	if($result == $CVAL::PCRM_RESULT_OK){
		printf("<p>С %s ɲäޤ</p>", util::get_encoded_html($added_account));
	}elsif($result == $CVAL::PCRM_RESULT_ERROR_ALREADY_FOUND){
		printf("<p>С %s ϴϿƤޤ</p>", util::get_encoded_html($account));
	}elsif($result == $CVAL::PCRM_RESULT_ERROR_MEMBER_FULL){
		printf("<p>С¤ãƤ뤿ϿǤޤ󡣴Ԥѹ褦ˤΤ餻</p>");
	}else{
		printf("<p>ե˥ǤʤʤɤΥ顼ȯޤ</p>");
	}
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<div><input type=\"submit\" value=\"ɽ\"></div></form>");

}

1; #return true 
