#!/usr/bin/perl

# Pangya Course Record Manager
#   util_mview.pl
# 
# Copyright(c)2006, T-MZ

use strict;
use Socket;
use FileHandle;

require './cgi-lib.pl';

package util_mview;

sub mview_main {
	my ($mview_param);
	$mview_param = shift;

	# ͤɤ߽Ф
	main::ReadParse(*main::data_in);

	# CGIإå
	print (main::PrintHeader());

	# HTMLإå
	&main::print_html_header ();

	&mview_view_main($mview_param);

	# HTMLեå
	&main::print_html_footer ();

}

sub mview_view_site_list {
	my ($local_name, $site_list_ref, $get_result_ref);
	$local_name = shift;
	$site_list_ref = shift;
	$get_result_ref = shift;
	
	my($site);
	printf ("<table summary=\"ext-site-list\"><tbody>");
	printf ("<tr><th>ά</th><th>̾ʥ֡</th><th>ɥ쥹</th><th></th></tr>");
	printf ("<tr><th>%s</th><td>%s</td><td>%s</td><td>%s</td></tr>",
	         $$local_name[0][0], $$local_name[0][1], $$local_name[0][2], "OK");
	foreach $site (@$site_list_ref){
		printf ("<tr><th>%s</th><td>%s</td><td>%s</td><td>%s</td></tr>",
		         $$site[0], $$site[1], $$site[2], $$get_result_ref{$$site[2]});
	}
	printf ("</tbody></table>");
}

sub mview_view_main {
	my ($mview_param);
	$mview_param = shift;
	
	my ($local_name, $site_list_ref, $mview_str_ref, %get_result);
	$local_name = $mview_param->{local_name};
	$site_list_ref = $mview_param->{site_list};
	$mview_str_ref = $mview_param->{mview_str};

	my ($result, %score);
	my ($site, $buf);
	
	$result = util::get_score_list(\%score, $$local_name[0][0]);
	printf("<p>%s</p>", $$mview_str_ref);
	if($result == $CVAL::PCRM_RESULT_OK){
		foreach $site (@$site_list_ref){
			my($status_code);
			$result = get_by_http($$site[2], \$buf, \$status_code);
			$get_result{$$site[2]} = $status_code;
			if($result == $CVAL::PCRM_RESULT_OK){
				$result = util::add_ext_score_list(\%score, \$buf, $$site[0]);
			}
		}
		main::view_table(\%score, $CVAL::VIEW_MODE_EXT_MERGE);
		mview_view_site_list($local_name, $site_list_ref, \%get_result);
	}else{
		print ("<p>եΥ˼Ԥޤ</p>");
	}
}

sub get_by_http {
	my ($target_url, $extdata_ref, $status_ref);
	$target_url = shift;
	$extdata_ref = shift;
	$status_ref = shift;

	my ($proxy_host, $proxy_port, $http_version);
	my ($con_host, $con_port);
	my ($host, $port, $url, $path, $ip, $sockaddr);
	my ($buf, $empty_line);
	
	$$extdata_ref = "";
	$$status_ref = "";
	$http_version = '1.1'; # HTTP/1.1 ǥ
	
	# ץФ
	#$proxy_host = 'XXX.XXX.XXX.XXX';
	#$proxy_port = 8080;
	
	# ǥեȥۥȤ
	$host = 'localhost';
	$port = getservbyname('http', 'tcp');
	$path = '/';
	
	# URLϽ
	$target_url =~ m!(http:)?(//)?([^:/]*)?(:([0-9]+)?)?(/.*)?!;
	if ($3) {$host = $3;}
	if ($5) {$port = $5;}
	if ($6) {$path = $6;}
	
	if ($proxy_host) {
	  # ץзͳ
	  $con_host = $proxy_host;
	  $con_port = $proxy_port;
	  $url = $target_url;
	} else {
	  $con_host = $host;
	  $con_port = $port;
	  $url = $path;
	}
	
	# åȤ
	if(!($ip = Socket::inet_aton($con_host))){
		$$status_ref = "host not found";
		return $CVAL::PCRM_RESULT_NG;
	}
	$sockaddr = Socket::pack_sockaddr_in($con_port, $ip);
	if(!(socket(SOCKET, Socket::PF_INET, Socket::SOCK_STREAM, 0))){
		$$status_ref = "socket error";
		return $CVAL::PCRM_RESULT_NG;
	}
	
	# åȤ³
	if(!(connect(SOCKET, $sockaddr))){
		$$status_ref = "connect error";
		return $CVAL::PCRM_RESULT_NG;
	}
	autoflush SOCKET (1);
	
	# HTTP׵
	if ($http_version eq '1.1') {
		print SOCKET "GET $url HTTP/1.1\n";
		print SOCKET "Host: $host\n";
		print SOCKET "Connection: close\n\n";
	
	} else {
		print SOCKET "GET $url HTTP/1.0\n\n";
	}
	
	# HTTPϡ
	
	my($chunk_flag);
	# إå
	$chunk_flag = 0;
	# 1ܡStatus-lineˤɤ
	$buf=<SOCKET>;
	if($buf =~ /^[^\s]* (\d*) (.*)$/){
		$$status_ref = "$1 $2";
		if($1 != 200){
			return $CVAL::PCRM_RESULT_NG;
		}
	}
	while (chomp($buf=<SOCKET>)) {
		if($buf =~ /^Transfer-Encoding.*:.*chunked/){
			# 
			$chunk_flag = 1;
		}
		if($buf =~ /^[\r\n]*$/){
			# إåλ
			last;
		}
	}

	if ($chunk_flag) {
		# 󥯤Υǥ
		my($chunk_size);
		$buf=<SOCKET>;
		$chunk_size = hex($buf);
		while($chunk_size > 0){
			read(SOCKET, $buf, $chunk_size);
			$$extdata_ref .= $buf;
			$buf=<SOCKET>;
			$chunk_size = hex($buf);
		}
	}else{
		while (chomp($buf=<SOCKET>)) {
			$$extdata_ref .= $buf;
		}
	}
	
	# 
	close(SOCKET);

	return $CVAL::PCRM_RESULT_OK;
}

1; #return true 
