use strict;

package util;

# ֤ͤ
sub max {
	my @data = @_;
	
	return if @data == 0;
	
	my $max = shift @data;
	foreach my $val (@data) {
		if ($max < $val) {
			$max = $val;
		}
	}
	return $max;
}

# Ǿ֤ͤ
sub min {
	my @data = @_;
	
	return if @data == 0;
	
	my $max = shift @data;
	foreach my $val (@data) {
		if ($max > $val) {
			$max = $val;
		}
	}
	return $max;
}

# ǥХåѥեϥϥɥ򳫤
sub prepare_debug_out{
	my $filename = shift;
	if ($conf::debug_file_out != 0) {
		open (DEBUG_OUT, ">> $filename");
	}
}

# ǥХåѥեϥϥɥĤ
sub end_debug_out{
	if ($conf::debug_file_out != 0) {
		close (DEBUG_OUT);
	}
}

# ǥХå
sub debug_print{
	my @param = @_;
	if ($conf::debug_file_out != 0) {
		printf (DEBUG_OUT @param);
	}
}

sub PrintTime_for_DebugLog {
	my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst, $cur_time) = 0;

	if ($conf::debug_file_out != 0) {
		$cur_time = time();
		($sec, $min, $hour, $mday, $mon, $year,
		        $wday, $yday, $isdst) =
		         localtime($cur_time);
		$year += 1900;
		$mon +=1;

		printf (DEBUG_OUT "%02d/%02d %02d:%02d:%02d", $mon, $mday, $hour, $min, $sec);
	}
}

# Ƽå
sub write_lock_method {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_NG;

	if($conf::setting_lock_method == $CVAL::PCRM_EXCLUSIVE_METHOD_FLOCK){
		$result = lock_flock_write ($lock_handle);
	}elsif($conf::setting_lock_method == $CVAL::PCRM_EXCLUSIVE_METHOD_RENAME){
		$result = lock_rename_write ($lock_handle);
	}else{
		# ѥ᡼顼
	}

	return ($result);
}
sub read_lock_method {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_NG;

	if($conf::setting_lock_method == $CVAL::PCRM_EXCLUSIVE_METHOD_FLOCK){
		$result = lock_flock_read ($lock_handle);
	}elsif($conf::setting_lock_method == $CVAL::PCRM_EXCLUSIVE_METHOD_RENAME){
		$result = lock_rename_read ($lock_handle);
	}else{
		# ѥ᡼顼
	}

	return ($result);
}
sub unlock_method {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_NG;

	if($conf::setting_lock_method == $CVAL::PCRM_EXCLUSIVE_METHOD_FLOCK){
		$result = lock_flock_release ($lock_handle);
	}elsif($conf::setting_lock_method == $CVAL::PCRM_EXCLUSIVE_METHOD_RENAME){
		$result = lock_rename_release ($lock_handle);
	}else{
		# ѥ᡼顼
	}

	return ($result);
}

# 񤭹ߥå(flock)
sub lock_flock_write {
	my $lock_handle = shift;
	my $handle = $$lock_handle{handle};
	my $result = $CVAL::PCRM_RESULT_OK;
	
	flock($handle, 2);
	return ($result)
}

# ɤ߹ߥå(flock)
sub lock_flock_read {
	my $lock_handle = shift;
	my $handle = $$lock_handle{handle};
	my $result = $CVAL::PCRM_RESULT_OK;

	flock($handle, 1);
	return ($result)
}

# å(flock)
sub lock_flock_release {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_OK;

	# ⤷ʤʥϥɥĤȤ˲

	return ($result)
}

# 񤭹ߥå(rename)
sub lock_rename_write {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_OK;

	do{
		$result = lock_rename_main ($lock_handle);
	}while($result == $CVAL::PCRM_RESULT_ERROR_FILE_LOCKED);

	return ($result)
}

# ɤ߹ߥå(rename)
# 񤭹ߥåƱԤ
sub lock_rename_read {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_OK;

	do{
		$result = lock_rename_main ($lock_handle);
	}while($result == $CVAL::PCRM_RESULT_ERROR_FILE_LOCKED);

	return ($result)
}

# å(rename) ѽ
sub lock_rename_main {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_OK;

	my $tmp_file_name;

	my @filelist;
	$$lock_handle{rename_dir} = $CVAL::setting_lock_dir;
	$$lock_handle{rename_basename} =  &GetRenameTargetFilename ($$lock_handle{file_name});
	$$lock_handle{rename_trytime} =  $conf::setting_rename_lock_force_release_trytime;
	$$lock_handle{rename_timeout} =  $conf::setting_rename_lock_force_release_timeout;
	$$lock_handle{rename_org} = $$lock_handle{rename_dir} . "/" . $$lock_handle{rename_basename};

	# ̾Υå
	for (my $i = 0; $i < $$lock_handle{rename_trytime}; $i++){
		$$lock_handle{rename_own} = $$lock_handle{rename_org} . "_" . time;
		if (rename($$lock_handle{rename_org}, $$lock_handle{rename_own})){
			return($result);
		}
		sleep(1);
	}

	# åǤʤΤǡߤ
	# ʥå򤫤ץ˽λк
	opendir(LOCKDIR, $$lock_handle{rename_dir});
	@filelist = readdir(LOCKDIR);
	closedir(LOCKDIR);
	foreach (@filelist) {
		if (/^$$lock_handle{rename_basename}_(\d+)/) {
			$$lock_handle{rename_own} = $$lock_handle{rename_org} . "_" . time;
			$tmp_file_name = $$lock_handle{rename_dir} . "/" . $_;
			if ((time - $1 > $$lock_handle{rename_timeout} ) and
			    (rename($tmp_file_name, $$lock_handle{rename_own}))){
				return($result);
			}
			last;
		}
	}
	$result = $CVAL::PCRM_RESULT_ERROR_FILE_LOCKED;
	return($result);
}

# å(rename)
sub lock_rename_release {
	my $lock_handle = shift;
	my $result = $CVAL::PCRM_RESULT_NG;

	# åե򸵤᤹
	if (rename($$lock_handle{rename_own}, $$lock_handle{rename_org})){
		$result = $CVAL::PCRM_RESULT_OK;
	}

	return($result);
}

# renameΥåѤΥե̾ʥǥ쥯ȥʤˤ
sub GetRenameTargetFilename {
	my $SourceFilename = shift;

	if ($SourceFilename =~ /([^\/]+)$/) {
		return ($1);
	}
	return ("");
}

sub get_account_file_name {

	return ($CVAL::setting_data_dir . "/" . $CVAL::setting_file_score);
}

sub get_account_temp_file_name {

	return ($CVAL::setting_data_dir . "/" . $CVAL::setting_file_score_temp);
}

sub get_score_file_name {

	return ($CVAL::setting_data_dir . "/" . $CVAL::setting_file_score);
}

sub get_score_temp_file_name {

	return ($CVAL::setting_data_dir . "/" . $CVAL::setting_file_score_temp);
}

# ɲ
sub account_add{
	my ($added_account_ref, $account, $passwd);
	$added_account_ref = shift;
	$account = shift;
	$passwd = shift;

	my ($acfile, $err_flg, $ac_exist);
	my %lock_handle_ac;

	$acfile = util::get_account_file_name();
	$ac_exist = 0;

	# бʸκ
	$account =~ s/[\t\n]//g;

	if (! $err_flg){
		if($account eq ""){
			$err_flg = 1;
		}
	}

	if (! $err_flg){
		# 񤭹ߥå
		if (!open (AC_FILE, "+< $acfile")){
			# open
			$err_flg = 1;
			&util::debug_print("failed open %s \n", $acfile);
		}
	}
	if (! $err_flg){
		$lock_handle_ac{handle} = *AC_FILE;
		$lock_handle_ac{file_name} = $acfile;
		&util::write_lock_method (\%lock_handle_ac);
		{
			# ¸ΥȤǤϤʤǧ
			my ($line, @line_sp, @line_new);
			while($line = <AC_FILE>){
				my $l_ac;
				@line_sp = split(/\t/, $line);
				$l_ac = $line_sp[0];
				if($l_ac eq $account){
					# ¸
					$ac_exist = 1;
					last;
				}
			}
			
			if(! $ac_exist){
				# եɲ
				$line_new[0] = $account;
				$line_new[1] = util::get_encrypted_passwd($passwd);
				$line = join("\t", @line_new);
				$line .= "\n";
				print (AC_FILE $line);
			}
		}
		# å
		&util::unlock_method (\%lock_handle_ac);
	}
	close (AC_FILE);

	$$added_account_ref = $account;
	if($ac_exist){
		return $CVAL::PCRM_RESULT_ERROR_ALREADY_FOUND;
	}elsif($err_flg){
		return $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
	}
	return $CVAL::PCRM_RESULT_OK;

}

# Ȱ
sub get_account_list{
	my ($account_list_ref);
	$account_list_ref = shift;

	my ($acfile, $err_flg);
	my @account_list;
	my %lock_handle_ac;

	$acfile = get_account_file_name();

	# ɤ߹ߥå
	if (!open (AC_FILE, "+< $acfile")){
		# open
		$err_flg = 1;
		&debug_print("failed open %s ", $acfile);
	}
	if (! $err_flg){
		$lock_handle_ac{handle} = *AC_FILE;
		$lock_handle_ac{file_name} = $acfile;
		&read_lock_method (\%lock_handle_ac);
		{
			# ¸ΥȤ˥å
			my ($line, @line_sp);
			while($line = <AC_FILE>){
				@line_sp = split(/[\t\n]/, $line);
				if($line_sp[0] ne ''){
					push (@account_list, $line_sp[0]);
				}
			}
		}
		# å
		&unlock_method (\%lock_handle_ac);
	}
	close (AC_FILE);

	@$account_list_ref = @account_list;
	if($err_flg){
		return $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
	}
	return $CVAL::PCRM_RESULT_OK;

}

# 
sub get_score_list{
	my ($score_hash_ref, $local_name);
	$score_hash_ref = shift;
	$local_name = shift;

	my ($acfile, $err_flg);
	my @account_list;
	my %account_hash;
	my %lock_handle_ac;

	$acfile = get_score_file_name();

	# ɤ߹ߥå
	if (!open (AC_FILE, "+< $acfile")){
		# open
		$err_flg = 1;
		&debug_print("failed open %s ", $acfile);
	}
	if (! $err_flg){
		$lock_handle_ac{handle} = *AC_FILE;
		$lock_handle_ac{file_name} = $acfile;
		&read_lock_method (\%lock_handle_ac);
		{
			# ¸ΥȤ˥å
			my $cnt = 0;
			my ($line, @line_sp);
			while($line = <AC_FILE>){
				my %scores;
				my ($lpos, $sckey);
				@line_sp = split(/[\t\n]/, $line);
				$scores{NAME} = $line_sp[0];
				$scores{COMMENT} = $line_sp[2];
				$scores{SITE} = $local_name;
				$lpos = $CVAL::PCRM_FILE_POS_START_CS;
				foreach $sckey (@CVAL::cs_list){
					my %scr;
					set_score(\$scr{SCORE} , \$scr{MOD} , $line_sp[$lpos++], $line_sp[$lpos++]);
					$scores{$sckey} = \%scr;
				}
				$account_hash{$line_sp[0]} = \%scores;
				$cnt++;
			}
		}
		# å
		&unlock_method (\%lock_handle_ac);
	}
	close (AC_FILE);

	%$score_hash_ref = %account_hash;
	if($err_flg){
		return $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
	}
	return $CVAL::PCRM_RESULT_OK;

}

# ȥǡѴưɲ
sub add_ext_score_list{
	my ($score_hash_ref, $extdata_ref, $ext_site_name);
	$score_hash_ref = shift;
	$extdata_ref = shift;
	$ext_site_name = shift;

	my ($line, @line_sp);
	foreach $line(split(/\n/, $$extdata_ref)){
		my %scores;
		my ($lpos, $sckey);
		@line_sp = split(/[\t\n]/, $line);
		$scores{NAME} = $line_sp[0];
		$scores{COMMENT} = $line_sp[2];
		$scores{SITE} = $ext_site_name;
		$lpos = $CVAL::PCRM_FILE_POS_START_CS;
		foreach $sckey (@CVAL::cs_list){
			my %scr;
			set_score(\$scr{SCORE} , \$scr{MOD} , $line_sp[$lpos++], $line_sp[$lpos++]);
			$scores{$sckey} = \%scr;
		}
		$$score_hash_ref{$line_sp[0]} = \%scores;
	}
	return $CVAL::PCRM_RESULT_OK;
}

# 򥻥å
sub set_score{
	my ($score_ref, $mod_time_ref, $file_dat, $file_mod);
	$score_ref = shift;
	$mod_time_ref = shift;
	$file_dat = shift;
	$file_mod = shift;

	if(($file_dat eq '')||($file_dat >= $CVAL::PCRM_NO_RECORD_VAL_MIN)){
		$file_dat = $CVAL::PCRM_NO_RECORD_VAL;
	}
	if($file_mod eq ''){
		$file_mod = 0;
	}
	$$score_ref = $file_dat;
	$$mod_time_ref = $file_mod;
	return $CVAL::PCRM_RESULT_OK;
}

# 1桼
sub get_target_user_data{
	my ($account, $dat_ref);
	$account = shift;
	$dat_ref = shift;

	my ($acfile, $err_flg, $find_flg);
	my (%scores);
	my %lock_handle_ac;

	$acfile = get_score_file_name();
	$find_flg = 0;

	# ɤ߹ߥå
	if (!open (AC_FILE, "+< $acfile")){
		# open
		$err_flg = 1;
		&debug_print("failed open %s ", $acfile);
	}
	if (! $err_flg){
		$lock_handle_ac{handle} = *AC_FILE;
		$lock_handle_ac{file_name} = $acfile;
		&read_lock_method (\%lock_handle_ac);
		{
			# оݥȤõ
			my ($line, @line_sp);
			while($line = <AC_FILE>){
				@line_sp = split(/[\t\n]/, $line);
				if($account eq $line_sp[0]){
					$find_flg = 1;
					my ($lpos, $sckey, %scr);
					$scores{NAME} = $line_sp[0];
					$scores{PASSWD} = $line_sp[1];
					$scores{COMMENT} = $line_sp[2];
					$lpos = $CVAL::PCRM_FILE_POS_START_CS;
					foreach $sckey (@CVAL::cs_list){
						my %scr;
						set_score(\$scr{SCORE} , \$scr{MOD} , $line_sp[$lpos++], $line_sp[$lpos++]);
						$scores{$sckey} = \%scr;
					}
					last;
				}
			}
		}
		# å
		&unlock_method (\%lock_handle_ac);
	}
	close (AC_FILE);

	if($err_flg){
		return $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
	}
	if($find_flg == 0){
		&debug_print("account[%s] not found\n", $account);
		return $CVAL::PCRM_RESULT_NG;
	}
	
	%$dat_ref = %scores;

	return $CVAL::PCRM_RESULT_OK;
}

# 1桼򹹿
sub set_target_user_data{
	my ($account, $dat_ref);
	$account = shift;
	$dat_ref = shift;

	my ($acfile, $err_flg, $find_flg);
	my ($ac_temp_file);
	my (%scores, $result, $line);
	my %lock_handle_ac;

	%scores = %$dat_ref;
	$acfile = get_score_file_name();
	$ac_temp_file = get_score_temp_file_name();
	$find_flg = 0;

	# 񤭹ߥå
	if (!open (AC_FILE, "+< $acfile")){
		# open
		$err_flg = 1;
		$result = $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
		&debug_print("failed open %s ", $acfile);
	}
	if (! $err_flg){
		$lock_handle_ac{handle} = *AC_FILE;
		$lock_handle_ac{file_name} = $acfile;
		&write_lock_method (\%lock_handle_ac);
	
		# եɤ߽񤭥⡼ɤǳ
		if (!open (AC_TEMP, "+> $ac_temp_file")){
			#open
			&debug_print("ac temporary can't open\n");
			$err_flg = 1;
			$result = $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
		}

		{
			# оݥȤõ
			my (@line_sp);
			while($line = <AC_FILE>){
				@line_sp = split(/[\t\n]/, $line);
				if($account eq $line_sp[0]){
					# оݥȤξѹ
					$find_flg = 1;
					my ($lpos, $sckey, %scr);
					if($scores{PASSWD} ne ''){
						$line_sp[1] = $scores{PASSWD};
					}
					$line_sp[2] = $scores{COMMENT};
					$lpos = $CVAL::PCRM_FILE_POS_START_CS;
					foreach $sckey (@CVAL::cs_list){
						my %scr;
						if($scores{$sckey}{SCORE} ne ''){
							$line_sp[$lpos] = $scores{$sckey}{SCORE};
						}
						$lpos++;
						if($scores{$sckey}{MOD} ne ''){
							$line_sp[$lpos] = $scores{$sckey}{MOD};
						}
						$lpos++;
					}
					$line = join("\t", @line_sp);
					$line .= "\n";
					print (AC_TEMP $line);
				}else{
					# Τޤ޵Ͽ
					print (AC_TEMP $line);
				}
			}
			truncate(AC_TEMP, tell(AC_TEMP));

			# ¾åݻޤ޸Υե˽᤹
			seek(AC_FILE, 0, 0);
			seek(AC_TEMP, 0, 0);
		
			while($line = <AC_TEMP>){
				print (AC_FILE $line);
			}
			truncate(AC_FILE, tell(AC_FILE));
		}

		# å
		&unlock_method (\%lock_handle_ac);
	}

	close (AC_TEMP);
	close (AC_FILE);

	if (! $err_flg){
		if (!unlink($ac_temp_file)){
			$result = $CVAL::PCRM_RESULT_ERROR_FILE_OPERATION;
			$err_flg = 1;
		}
	}

	if($err_flg){
		return $result;
	}

	if($find_flg == 0){
		&debug_print("account[%s] not found\n", $account);
		return $CVAL::PCRM_RESULT_NG;
	}
	
	return $CVAL::PCRM_RESULT_OK;
}

# Υ桼
sub delete_target_user_data{
	my ($account);
	$account = shift;

	my ($acfile, $err_flg, $find_flg);
	my ($ac_temp_file);
	my (%scores, $result, $line);
	my %lock_handle_ac;

	$acfile = get_score_file_name();
	$ac_temp_file = get_score_temp_file_name();
	$find_flg = 0;

	# 񤭹ߥå
	if (!open (AC_FILE, "+< $acfile")){
		# open
		$err_flg = 1;
		$result = $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
		&debug_print("failed open %s ", $acfile);
	}
	if (! $err_flg){
		$lock_handle_ac{handle} = *AC_FILE;
		$lock_handle_ac{file_name} = $acfile;
		&write_lock_method (\%lock_handle_ac);
	
		# եɤ߽񤭥⡼ɤǳ
		if (!open (AC_TEMP, "+> $ac_temp_file")){
			#open
			&debug_print("ac temporary can't open\n");
			$err_flg = 1;
			$result = $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
		}

		{
			# оݥȤõ
			my (@line_sp);
			while($line = <AC_FILE>){
				@line_sp = split(/[\t\n]/, $line);
				if($account eq $line_sp[0]){
					# Ͽʤ
					$find_flg = 1;
				}else{
					# Τޤ޵Ͽ
					print (AC_TEMP $line);
				}
			}
			truncate(AC_TEMP, tell(AC_TEMP));

			# ¾åݻޤ޸Υե˽᤹
			seek(AC_FILE, 0, 0);
			seek(AC_TEMP, 0, 0);
		
			while($line = <AC_TEMP>){
				print (AC_FILE $line);
			}
			truncate(AC_FILE, tell(AC_FILE));
		}

		# å
		&unlock_method (\%lock_handle_ac);
	}

	close (AC_TEMP);
	close (AC_FILE);

	if (! $err_flg){
		if (!unlink($ac_temp_file)){
			$result = $CVAL::PCRM_RESULT_ERROR_FILE_OPERATION;
			$err_flg = 1;
		}
	}

	if($err_flg){
		return $result;
	}

	if($find_flg == 0){
		&debug_print("account[%s] not found\n", $account);
		return $CVAL::PCRM_RESULT_NG;
	}
	
	return $CVAL::PCRM_RESULT_OK;
}

# ݡ
sub exec_export_data{
	my ($sup_comment);
	$sup_comment = shift;

	my ($acfile, $err_flg);
	my @account_list;
	my %account_hash;
	my %lock_handle_ac;
	my $data_str;

	$acfile = get_score_file_name();

	# ɤ߹ߥå
	if (!open (AC_FILE, "+< $acfile")){
		# open
		$err_flg = 1;
		&debug_print("failed open %s ", $acfile);
	}
	if (! $err_flg){
		$lock_handle_ac{handle} = *AC_FILE;
		$lock_handle_ac{file_name} = $acfile;
		&read_lock_method (\%lock_handle_ac);
		{
			my $cnt = 0;
			my ($line, @line_sp);
			while($line = <AC_FILE>){
				my %scores;
				my ($lpos, $sckey);
				@line_sp = split(/[\t\n]/, $line);
				if($#line_sp >= 1){
					# ѥɤʸ֤
					@line_sp[1] = "";
				}
				if($sup_comment){
					if($#line_sp >= 2){
						# Ȥʸ֤
						@line_sp[2] = "";
					}
				}
				$line = join("\t", @line_sp);
				$line .= "\n";
				$data_str .= $line;
			}
		}
		# å
		&unlock_method (\%lock_handle_ac);
	}
	close (AC_FILE);

	# ǡ
	print($data_str);

	if($err_flg){
		return $CVAL::PCRM_RESULT_ERROR_FILE_OPEN;
	}
	return $CVAL::PCRM_RESULT_OK;
}

# ǧ
sub exec_auth{
	my ($account, $enter_passwd);
	$account = shift;
	$enter_passwd = shift;

	my ($result, %score, $enc_passwd);
	$result = get_target_user_data ($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		&debug_print("get_target_user_data failed\n");
		return $result;
	}

	$enc_passwd = $score{PASSWD};
	$result = check_passwd($enter_passwd, $enc_passwd);
	if ($result != $CVAL::PCRM_RESULT_OK)
	{
		return $result;
	}
	
	return $CVAL::PCRM_RESULT_OK;
}

# ѥɤŹ沽
sub get_encrypted_passwd{
	my ($passwd);
	my ($enc_passwd, $salt, $ctab);
	$passwd = shift;
	
	srand();
	$ctab = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	$salt = substr($ctab,int(rand(64)),1) . substr($ctab,int(rand(64)),1);
	$enc_passwd = crypt($passwd, $salt);
	return $enc_passwd;
}

# ѥɤå
sub check_passwd{
	my ($passwd, $enc_passwd);
	$passwd = shift;
	$enc_passwd = shift;
	
	if ($enc_passwd ne crypt($passwd, $enc_passwd)){
		return $CVAL::PCRM_RESULT_NG;
	}
	return $CVAL::PCRM_RESULT_OK;
}

# ץʸ(for HTML)
sub get_script_copyright_HTML{
	return "&copy;2006, T-MZ.";
}

# ѥʸ(for HTML)
sub get_pangya_copyright_HTML{
	return "&copy;2004 Ntreev Soft Co.,Ltd. All Rights Reserved.<br >Exclusive License &copy;2004 HanbitSoft, Inc., All rights reserved.<br >&copy;2004 Gamepot Inc., All rights reserved.";
}

# ʸѴ
sub get_replaced_name_with_icon {
	my ($src, $rep, @rep_list, @rep_set, $rep_set_temp);
	$src = shift;

	$rep = $src;
	$rep =~ s/&/&amp\;/g;
	$rep =~ s/</&lt\;/g;
	$rep =~ s/>/&gt\;/g;
	if($conf::enable_name_icon_replace){
		foreach $rep_set_temp (@CVAL::eicon_table){
			$rep_set[0] = "". $$rep_set_temp[0] . "";
			$rep_set[1] = sprintf("<img src=\"%s/%s\" width=\"%d\" height=\"%d\" alt=\"%s\" >",
			                      $CVAL::setting_eicon_dir,
			                      $$rep_set_temp[1],
			                      $$rep_set_temp[2],
			                      $$rep_set_temp[3],
			                      $$rep_set_temp[0]);
			$rep =~ s/$rep_set[0]/$rep_set[1]/g;
		}
	}

	return $rep;
}

# HTML˱ƶΤʬѴ
sub get_encoded_html {
	my ($src, $rep);
	$src = shift;

	$rep = $src;
	$rep =~ s/&/&amp\;/g;
	$rep =~ s/</&lt\;/g;
	$rep =~ s/>/&gt\;/g;

	return $rep;
}

# EUCޤʸʸʲڤФ
sub get_substr_euc {
	my ($src, $size);
	$src = shift;
	$size = shift;

	my ($str);
	my ($chr_ascii, $chr_2bytes, $chr_3bytes, $euc_1chr);
	$chr_ascii = '[\x00-\x7F]';
	$chr_2bytes = '[\x8E\xA1-\xFE][\xA1-\xFE]';
	$chr_3bytes = '\x8F[\xA1-\xFE][\xA1-\xFE]';
	$euc_1chr = "($chr_ascii|$chr_2bytes|$chr_3bytes)";

	$str = "";
	if($src =~ /^((?:$euc_1chr){0,$size}).*/o){
		$str = $1;
	}
}

1; #return true 
