#!/usr/bin/perl

# Pangya Course Record Manager
#   admin.cgi
# 
# Copyright(c)2006, T-MZ

use strict;
use vars qw(%data_in);

require './cgi-lib.pl';
require './const.pl';
require './util.pl';
require './config.pl';

$main::PCRM_ADMIN_MODE_EDIT_SETTING = "edit-setting";
$main::PCRM_ADMIN_MODE_SETTING_ACCOUNT = "account";
$main::PCRM_ADMIN_SETTING_KIND_ADD = "add";
$main::PCRM_ADMIN_SETTING_KIND_PASSCHG = "passchg";
$main::PCRM_ADMIN_SETTING_KIND_DELETE = "delete";

# ᥤƤӽФ
&mainfunc();
exit (0);

sub mainfunc {
	&util::prepare_debug_out("./debug/admin_log.txt");
	&util::PrintTime_for_DebugLog;
	&util::debug_print("\n");

	# ͤɤ߽Ф
	ReadParse(*data_in);
#	@get_key = keys %data_in; #ꥹȼ
#	$ele_num = keys %data_in; #ǿ

	# CGIإå
	print (PrintHeader());

	# HTMLإå
	&print_html_header ();

	&print_set_part();

	# HTMLեå
	&print_html_footer ();

	&util::end_debug_out();
}

sub print_html_header {
	print ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"><html lang=\"ja-JP\">\n");
	print ("<head><meta http-equiv=\"Content-type\" content=\"text/html; charset=EUC-JP\">\n");
	print ("<title>ΥС</title>\n");
	print ("<link rel=\"STYLESHEET\" type=\"text/css\" href=\"./admin.css\" ></head>\n");
	print ("<body>\n");
}

sub print_html_footer {
	print ("</body></html>\n");
}

# ˥塼ܥ
sub print_goto_setting_menu {
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>\n");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_ADMIN_MODE_EDIT_SETTING\" ></div>");
	print ("<div><input type=\"hidden\" name=\"passwd\" value=\"$data_in{'passwd'}\" ></div>");
	print ("<div><input type=submit value=\"˥塼\"></div></form>\n");
}

sub print_goto_menu {
}

sub print_auth_failure {
	print ("<p><span class=\"caution\">ѥɤְäƤޤ</span></p>\n");
	&print_goto_menu ();
}

sub print_set_part {

	# ѥѹǧ
	if ($conf::setting_admin_password eq $CVAL::default_passwd){
		print ("<p><span class=\"caution\">ѥɤΤΤѹƤʤưޤ</span></p>\n");
		print ("<p><span class=\"caution\">local_config.cgiѹƤ</span></p>\n");
		return;
	}

	# ǧ
	if ($data_in{'passwd'} ne $conf::setting_admin_password)
	{
		if ($data_in{'mode'} eq ""){
			&print_select_mode ();
		}else{
			&print_auth_failure ();
		}
	}
	else
	{
		# ⡼ɤڤʬ
		if ($data_in{'mode'} eq $main::PCRM_ADMIN_MODE_EDIT_SETTING)
		{
			&exec_edit_accounts();
		}
	}
}

sub print_select_mode {
	print ("<p>С </p>");
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=\"POST\">");
	print ("<div><input type=\"hidden\" name=\"part\" value=\"$main::PCRM_SV_ADMIN_PART_SET\" ></div>");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_ADMIN_MODE_EDIT_SETTING\" ></div>");
	print ("<div><input type=\"hidden\" name=\"set-mode\" value=\"$main::PCRM_ADMIN_MODE_SETTING_ACCOUNT\" ></div>");
	print ("<div>ѥ<input type=\"password\" name=\"passwd\" size=\"20\" value=\"\"></div>");
	print ("<div><input type=\"submit\" value=\"\"></div></form>\n");
}

# СԽ
sub exec_edit_accounts{
	# Խ⡼ɤڤʬ
	if ($data_in{'set-kind'} eq $main::PCRM_ADMIN_SETTING_KIND_ADD)
	{
		&exec_edit_account_add ();
	}
	elsif ($data_in{'set-kind'} eq $main::PCRM_ADMIN_SETTING_KIND_PASSCHG)
	{
		&exec_edit_account_passchg ();
	}
	elsif ($data_in{'set-kind'} eq $main::PCRM_ADMIN_SETTING_KIND_DELETE)
	{
		&exec_edit_account_delete ();
	}
	else{
		&print_select_account_kind ();
	}
}

# С
sub print_select_account_kind{
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>");
	print ("<div><input type=\"hidden\" name=\"passwd\" value=\"$data_in{'passwd'}\" ></div>");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_ADMIN_MODE_EDIT_SETTING\" ></div>");
	print ("<div><input type=\"hidden\" name=\"set-mode\" value=\"$main::PCRM_ADMIN_MODE_SETTING_ACCOUNT\" ></div>");
	print ("<div><input type=\"radio\" name=\"set-kind\" value=\"$main::PCRM_ADMIN_SETTING_KIND_ADD\" >Сɲ</div>");
	print ("<div><input type=\"radio\" name=\"set-kind\" value=\"$main::PCRM_ADMIN_SETTING_KIND_PASSCHG\" >СΥѥѹ</div>");
	print ("<div><input type=\"radio\" name=\"set-kind\" value=\"$main::PCRM_ADMIN_SETTING_KIND_DELETE\" >Сκ</div>");
	print ("<div><input type=\"submit\" value=\"\"></div></form>\n");
	&print_goto_setting_menu ();
	&print_goto_menu ();

}

# Сɲå⡼
sub exec_edit_account_add{
	# ֤ڤʬ
	if ($data_in{'account'} eq "")
	{
		&print_edit_account_add ();
	}
	else{
		&exec_edit_account_add_show ();
	}
}

# Сɲ
sub exec_edit_account_add_show{
	my ($account, $pass1, $pass2, $result, $added_account);

	$account = $data_in{'account'};
	$pass1 = $data_in{'pass1'};
	$pass2 = $data_in{'pass2'};

	if ($pass1 ne $pass2){
		printf("<p>ѥɤפƤޤ</p>");
		return;
	}

	$result = util::account_add(\$added_account, $account, $pass1);
	if($result == $CVAL::PCRM_RESULT_OK){
		printf("<p>С %s ɲäޤ</p>", $added_account);
	}elsif($result == $CVAL::PCRM_RESULT_ERROR_ALREADY_FOUND){
		printf("<p>С %s ϴˤ뤿ϿǤޤ</p>", $account);
	}else{
		printf("<p>ե˥ǤʤʤɤΥ顼ȯޤ</p>");
	}

	&print_goto_setting_menu ();
	&print_goto_menu ();
}

sub print_edit_account_add{
	print ("<p>ѥɤˤϡȾѱѿȰε_!#\$\%&amp;'()+-*/=~{}?@.ˤΤ߻ѲǽǤ</p>");
	print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>");
	print ("<div><input type=\"hidden\" name=\"passwd\" value=\"$data_in{'passwd'}\" ></div>");
	print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_ADMIN_MODE_EDIT_SETTING\" ></div>");
	print ("<div><input type=\"hidden\" name=\"set-mode\" value=\"$main::PCRM_ADMIN_MODE_SETTING_ACCOUNT\" ></div>");
	print ("<div><input type=\"hidden\" name=\"set-kind\" value=\"$main::PCRM_ADMIN_SETTING_KIND_ADD\" ></div>");
	print ("<div>С<input type=\"text\" name=\"account\" value=\"\" size=\"18\" ></div>");
	print ("<div>ѥ<input type=\"password\" name=\"pass1\" size=\"20\" ></div>");
	print ("<div>ѥ<input type=\"password\" name=\"pass2\" size=\"20\" >ʺϡ</div>");
	print ("<div><input type=\"submit\" value=\"ɲ\"></div></form>\n");

	&print_goto_setting_menu ();
	&print_goto_menu ();
}

# СΥѥѹ
sub exec_edit_account_passchg{
	# ֤ڤʬ
	if ($data_in{'account'} eq "")
	{
		&print_edit_account_passchg ();
	}
	else{
		&exec_edit_account_passchg_show ();
	}
}

sub exec_edit_account_passchg_show{
	my ($account, $pass1, $pass2);

	$account = $data_in{'account'};
	$pass1 = $data_in{'pass1'};
	$pass2 = $data_in{'pass2'};

	my(%score, $result);

	if ($pass1 ne $pass2){
		printf("<p>ѥɤפƤޤ</p>");
		return;
	}elsif($pass1 eq ""){
		printf("<p>ѥɤꤵƤޤ</p>");
		return;
	}

	$result = util::get_target_user_data($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		printf("<p>С[%s]Υǡ˼Ԥޤ</p>", $account);
		return;
	}
	$score{PASSWD} = util::get_encrypted_passwd($pass1);

	$result = util::set_target_user_data($account, \%score);
	if($result != $CVAL::PCRM_RESULT_OK){
		printf("<p>С[%s]Υǡ˼Ԥޤ</p>", $account);
		return;
	}
	printf("<p>С[%s] Υѥɤѹޤ</p>", $account);

	&print_goto_setting_menu ();
	&print_goto_menu ();
}

sub print_edit_account_passchg{
	my(@account_list, $result);
	my($account);
	
	$result = util::get_account_list(\@account_list);

	if($result == $CVAL::PCRM_RESULT_OK){
		print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>");
		print ("<div><input type=\"hidden\" name=\"passwd\" value=\"$data_in{'passwd'}\" ></div>");
		print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_ADMIN_MODE_EDIT_SETTING\" ></div>");
		print ("<div><input type=\"hidden\" name=\"set-mode\" value=\"$main::PCRM_ADMIN_MODE_SETTING_ACCOUNT\" ></div>");
		print ("<div><input type=\"hidden\" name=\"set-kind\" value=\"$main::PCRM_ADMIN_SETTING_KIND_PASSCHG\" ></div>");
		print ("<div>С<select name=\"account\">");
		foreach $account (@account_list){
			print ("<option value=\"$account\">$account</option>");
		}
		print ("</select></div>");
		print ("<div>ѥ<input type=\"password\" name=\"pass1\" size=\"20\" ></div>");
		print ("<div>ѥ<input type=\"password\" name=\"pass2\" size=\"20\" >ʺϡ</div>");
		print ("<div><input type=\"submit\" value=\"ѥѹ\"></div></form>\n");
	}else{
		print ("<p>СեΥ˼Ԥޤ</p>");
	}

	&print_goto_setting_menu ();
	&print_goto_menu ();
}

# Сκ
sub exec_edit_account_delete{
	# ֤ڤʬ
	if ($data_in{'account'} eq "")
	{
		&print_edit_account_delete ();
	}
	else{
		&exec_edit_account_delete_show ();
	}
}

sub exec_edit_account_delete_show{
	my ($account, $result);

	$account = $data_in{'account'};

	$result = util::delete_target_user_data($account);
	if($result == $CVAL::PCRM_RESULT_OK){
		printf("<p>С %s ޤ</p>", $account);
	}else{
		printf("<p>ե˥ǤʤʤɤΥ顼ȯޤ</p>");
	}

	&print_goto_setting_menu ();
	&print_goto_menu ();
}

sub print_edit_account_delete{
	my(@account_list, $result);
	my($account);
	
	$result = util::get_account_list(\@account_list);

	if($result == $CVAL::PCRM_RESULT_OK){
		print ("<form action=\"$ENV{'SCRIPT_NAME'}\" method=POST>");
		print ("<div><input type=\"hidden\" name=\"passwd\" value=\"$data_in{'passwd'}\" ></div>");
		print ("<div><input type=\"hidden\" name=\"mode\" value=\"$main::PCRM_ADMIN_MODE_EDIT_SETTING\" ></div>");
		print ("<div><input type=\"hidden\" name=\"set-mode\" value=\"$main::PCRM_ADMIN_MODE_SETTING_ACCOUNT\" ></div>");
		print ("<div><input type=\"hidden\" name=\"set-kind\" value=\"$main::PCRM_ADMIN_SETTING_KIND_DELETE\" ></div>");
		print ("<div>С<select name=\"account\">");
		foreach $account (@account_list){
			print ("<option value=\"$account\">$account</option>");
		}
		print ("</select></div>");
		print ("<div><input type=\"submit\" value=\"С\"></div></form>\n");
	}else{
		print ("<p>СեΥ˼Ԥޤ</p>");
	}

	&print_goto_setting_menu ();
	&print_goto_menu ();
}

